﻿var dashboardResults =
{
    url: "",
    reportConfigurationId: 0,
    language: 'en',
    userLanguage: 'en',
    mainSection: null,
    questionNavigator: null,
    questionNavigatorTable: null,
    questionsSection: null,
    questions: new Array(),
    openEndAnswers: null,
    openEndAnswersTable: null,
    wordCloudText: "",
    selectedTopic: "",
    sentiments: "",
    surveyLanguages: "",
    wordCloudConfig: null,
    topicSearch: "",
    loadLastSelectedQuestionFlag: true
}

$(document).ready(function () {
    dashboardLoadResultsConfiguration();
    if (dashboardResults.mainSection.length > 0) {
        dashboardBindQuestionNavigator();
        dashboardQUestionStatus();
        checkAvailabilityOfQnsTable(1);
    }
    searchTopicEvent();
    $("#onDemandUpdate").hide();
});

function checkAvailabilityOfQnsTable(attemptNum) {
    var qnsTableCheckInterval;
    if (advancedAnalyticsModel) {
        var defaultVariableId = advancedAnalyticsModel.DefaultVariableId;
        if (defaultVariableId && defaultVariableId > 0) {
            qnsTableCheckInterval = setInterval(function () {
                if ($('tbody>tr', '.h-questionNavigatorDashboard-table').length > 0) {
                    clearInterval(qnsTableCheckInterval);
                    checkForDefaultDashboardLoadingForRequiredQuestion(defaultVariableId, attemptNum);
                }
            }, 1000);
        }
    }
}

function checkForDefaultDashboardLoadingForRequiredQuestion(defaultVariableId, attemptNum) {
    var allLoadedQuestions = $('tbody>tr', '.h-questionNavigatorDashboard-table');
    var filteredQuestion = null;

    _.find(allLoadedQuestions, function (item) {
        var currentQn = $(item);
        if (currentQn.data("variableId") === defaultVariableId) {
            filteredQuestion = currentQn;
            return true;
        }
        return false;
    });

    if (filteredQuestion) {
        questionClickEventHandler(filteredQuestion, true);
        filteredQuestion.get(0).scrollIntoView();
    }
    else if (attemptNum <= 3) {
        checkAvailabilityOfQnsTable(attemptNum + 1);
    }
}

function loadLastSelectedQuestionFromConfig(attemptNum) {
    let isRedirectionFromNps = advancedAnalyticsModel.DefaultVariableId > 0;
    if (isRedirectionFromNps)
        return;

    var qnsTableCheckInterval;
    if (selectedVariableId > 0 || textAnalysisQuestionConfig) {
        var variableIdOfQuestionTobeLoaded = selectedVariableId > 0 ? selectedVariableId : textAnalysisQuestionConfig.VariableId;
        qnsTableCheckInterval = setInterval(function () {
            if ($('tbody>tr', '.h-questionNavigatorDashboard-table').length > 0) {
                clearInterval(qnsTableCheckInterval);
                loadLastSelectedQuestion(variableIdOfQuestionTobeLoaded, attemptNum);
            }
        }, 1000);
    }
}
function loadLastSelectedQuestion(variableIdOfQuestionTobeLoaded, attemptNum) {
    var allLoadedQuestions = $('tbody>tr', '.h-questionNavigatorDashboard-table');
    var selectedQuestion = null;
    _.find(allLoadedQuestions, function (item) {
        var currentQn = $(item);
        if (currentQn.data("variableId") === variableIdOfQuestionTobeLoaded) {
            selectedQuestion = currentQn;
            return true;
        }
        return false;
    });

    if (selectedQuestion && dashboardResults.loadLastSelectedQuestionFlag) {
        questionClickEventHandler(selectedQuestion, false, true);
        selectedQuestion.get(0).scrollIntoView();
    }
    else if (attemptNum <= 3) {
        loadLastSelectedQuestionFromConfig(attemptNum + 1);
    }
}

function getQuestionsProgress() {
    setTimeout(dashboardQUestionStatus, 10000);
}
function dashboardQUestionStatus() {
    a4.callServerMethod(a4.getSurveyAction("GetDashboardQUestionStatus", "AdvancedAnalytics"), {
    }, function (response) {
        if (response.length != 0) {
            $('#DataTables_Table_0 tr td').each(function () {
                var row = $(this).parents("tr");
                var dashboardStatus = row.data("dashboardStatus");
                if (dashboardStatus === 'InProgress' || dashboardStatus === 'UpdateInProgress') {
                    let questions = response.filter(b => b['VariableId'] === row.data("variableId"));
                    if (questions && questions.length > 0) {
                        let questionStatus = questions[0]['Status'];
                        row.data("dashboardStatus", questionStatus);
                        if (questionStatus === 'Completed' || questionStatus === 'NotCreated') {
                            if (row.data("hasDashboard") == true) {
                                a4.showSuccessMessage(resources.DashboardSuccess);
                            }
                            $(".dashboard-status-icon", row).addClass("fa fa-pie-chart");
                            $(".dashboard-status-icon", row).find("span").remove();
                            row.data("hasDashboard", true);
                            if (selectedVariableId === questions[0]['VariableId']) {
                                setTimeout(() => {
                                    changeRowQuestionDisplay(row, true);
                                }, 2000);

                            }
                        } else if (questionStatus === 'Error') {
                            $(".dashboard-status-icon", row).removeClass("fa fa-pie-chart");
                            $(".dashboard-status-icon", row).addClass("fa fa-exclamation");
                            $(".dashboard-status-icon", row).find("span").remove();

                        } else if (dashboardStatus === 'UpdateInProgress') {
                            $(".dashboard-status-icon", row).removeClass("fa fa-pie-chart");
                            $(".dashboard-status-icon", row).removeClass("fa-circle-o-notch");
                            $(".dashboard-status-icon", row).removeClass("fa fa-exclamation");
                            if (!$(".dashboard-status-icon", row).hasClass("loading-icon")) {
                                $(".dashboard-status-icon", row).addClass("loading-icon").addClass("loading-icon").append($("<span class='fa fa-circle-o-notch fa-spin fa-fw'></span>"));
                            }

                        } else {

                            $(".dashboard-status-icon", row).removeClass("fa-circle-o-notch");
                            $(".dashboard-status-icon", row).removeClass("loading-icon");
                            $(".dashboard-status-icon", row).removeClass("fa fa-pie-chart");

                            if (!$(".dashboard-status-icon", row).hasClass("fa fa-exclamation")) {
                                $(".dashboard-status-icon", row).addClass("fa fa-exclamation");
                            }
                        }
                    }
                }
            });
        }
        getQuestionsProgress();
    })
}

$(window).on("resize", function () {
    generateCloud(dashboardResults.wordCloudText, dashboardResults.wordCloudConfig);
});

var selectedQuestionName = "";
var selectedVariableHasTopicAnalysis = "";
var selectedQuestionId = 0;
var selectedVariableId = 0;
var dashboardCreationDate = "";
var selectedQuestionText = "";
var selectedQuestionLanguage = "";
var selectedQuestionHasLanguageDetection = false;
var selectedQuestionHasTopicsEnabled = false;
var filterAnalytics = {};
var combinedTopicIds = [];

$('.dashboard-activate-survey').on("click", function () {
    var parameters = {
        surveyId: a4.getSurveyId()
    };
    var hasActivated = a4.getAction("StartAndDeploySurvey", "Shared", 'Survey');
    a4.callServerMethod(hasActivated, parameters, function (result) {
        if (result['success']) {
            window.location.reload();
        }
    });
})
$(".h-exportpng").on("click", function () {
    var dialogContent = {
        Title: resources.ExportPNGHeader, Message: resources.ExportPNGDescription, ConfirmButton: resources.Confirm
    };
    modalDialog.showConfirmDialog(dialogContent, function () { exportCharts('png'); });
});

$(".h-exportjpeg").on("click", function () {
    var dialogContent = { Title: resources.ExportJPEGHeader, Message: resources.ExportJPEGDescription, ConfirmButton: resources.Confirm };
    modalDialog.showConfirmDialog(dialogContent, function () { exportCharts('jpeg'); });
});

$(".h-exportpdf").on("click", function () {
    var dialogContent = { Title: resources.ExportPDFHeader, Message: resources.ExportPDFDescription, ConfirmButton: resources.Confirm };
    modalDialog.showConfirmDialog(dialogContent, function () { exportCharts('pdf'); });
});

$(".h-exportexcel").on("click", function () {
    var dialogContent = { iconRequired: true, Title: resources.ExportExcelHeader, Message: resources.ExportExcelDescription, ConfirmButton: resources.Confirm };
    modalDialog.showConfirmDialog(dialogContent, function () { exportExcel(); });
});

function exportExcel() {
    showLoader(resources.ExportExcelLoadText);
    postSentimentTrendImageToServer(3);

    function postSentimentTrendImageToServer(chartType) {
        html2canvas(document.querySelector(".sentiment-trendChart"), { useCORS: true }).then(canvas => {
            var type = "png";
            var dataType = `image/${type}`;
            var imageContent = canvas.toDataURL(dataType).replace('data:' + dataType + ';base64,', '');

            var params = { surveyId: a4.getSurveyId(), sentimentChartType: chartType, imageContent: imageContent };
            var url = a4.getAction("SaveImagesForExportExcel", "AdvancedAnalytics", "Survey");

            a4.callServerMethod(url, params, function (response) {
                if (response["RequestId"] && response["RequestId"] !== "00000000-0000-0000-0000-000000000000") {
                    generateAndDownloadExcelReport(response["RequestId"]);
                }
            });
        });
    }

    function generateAndDownloadExcelReport(requestId) {
        var OptionLastActivityType;

        if ($("#filterDateToday").is(':checked')) {
            OptionLastActivityType = 0;
        } else if ($("#filterDateThisMonth").is(':checked')) {
            OptionLastActivityType = 1;
        }
        else {
            OptionLastActivityType = 2;
        }

        var url = a4.getAction("ExportToExcel", "AdvancedAnalytics", "Survey",
            {
                variableId: selectedVariableId,
                surveyId: a4.getSurveyId(),
                questionName: selectedQuestionName,
                questionDesc: selectedQuestionText,
                surveyName: document.getElementsByClassName("survey-name")[0].textContent,
                topicName: dashboardResults.selectedTopic,
                filterFromDate: filterAnalytics.FromDate,
                filterToDate: filterAnalytics.ToDate,
                filterSentimentType: filterAnalytics.SentimentType,
                requestId: requestId,
                lastActivityType: OptionLastActivityType
            });
        window.location.href = url;
        setTimeout(() => {
            hideLoader();
        }, 2000);
    }

    _paq.push(['trackEvent', 'Survey-AdvancedAnalytics-TextAnalysis', 'Dashboard:Export', 'excel']);
}

function exportCharts(type) {
    showLoader(`${resources.ExportImageLoadText} ${type.toUpperCase()}`);

    var doc;
    var sentimentChartHeight;
    html2canvas(document.querySelector("#sentimentCharts"), { useCORS: true }).then(canvas => {
        type = type.toLowerCase();
        var filename = `${resources.Charts}.${type}`;

        if (type == "pdf") {
            var canvasWidth;
            var canvasHeight;
            var img = canvas.toDataURL("image/png", canvasWidth = canvas.width * 0.8, canvasHeight = canvas.height * 0.8);

            var ratio = canvasHeight / canvasWidth;

            doc = new jsPDF('p', 'pt', "a4");
            var width = doc.internal.pageSize.getWidth();
            var height = width * ratio;
            sentimentChartHeight = height;

            doc.addImage(img, 'JPEG', 0, 0, width, height);
        }
        else {
            var dataType = `image/${type}`;
            var url = canvas.toDataURL(dataType).replace(dataType, "image/octet-stream");

            var link = document.createElement("a");
            link.download = filename;
            link.href = url;
            link.click();
        }
        hideLoader();
    });

    // Downloading Sentiment Trend Chart
    html2canvas(document.querySelector(".sentiment-trendChart"), { useCORS: true }).then(canvas => {
        type = type.toLowerCase();
        var filename = `${resources.Charts}.${type}`;

        if (type == "pdf") {
            var canvasWidth;
            var canvasHeight;
            var img = canvas.toDataURL("image/png", canvasWidth = canvas.width * 0.8, canvasHeight = canvas.height * 0.8);

            var ratio = canvasHeight / canvasWidth;

            var width = doc.internal.pageSize.getWidth();
            var height = width * ratio;

            doc.addImage(img, 'JPEG', 0, sentimentChartHeight + 10, width, height);
            doc.save(filename);
        }
        else {
            var dataType = `image/${type}`;
            var url = canvas.toDataURL(dataType).replace(dataType, "image/octet-stream");

            var link = document.createElement("a");
            link.download = filename;
            link.href = url;
            link.click();
        }
        hideLoader();
    });

    _paq.push(['trackEvent', 'Survey-AdvancedAnalytics-TextAnalysis', 'Dashboard:Export', type]);
}

function openEndAnswer(variableId) {
    dashboardResults.openEndAnswers = $(".open-end-answers");
    if (dashboardResults.openEndAnswersTable) {
        dashboardResults.openEndAnswersTable.a4datatable("option", "ajaxParams", { "variableId": variableId, "topicName": dashboardResults.selectedTopic, "filterAnalytics": filterAnalytics });
        dashboardResults.openEndAnswersTable.a4datatable("refresh", true, true);
    }
    else {
        dashboardResults.openEndAnswersTable = $(".open-end-answers-table", dashboardResults.openEndAnswers).a4datatable({
            ajaxAction: a4.getSurveyAction("GetOpenEndAnswers", "AdvancedAnalytics"),
            ajaxParams: { "variableId": variableId, "topicName": dashboardResults.selectedTopic, "filterAnalytics": filterAnalytics },
            columns: [
                {
                    "Name": "ResponseText", "Title": "Comment", "Data": function (source, type, val) {
                        var jqhtml = $("<div>")
                            .append($("<div>").addClass("response-container")
                                .append($("<div>").addClass(`response-sentiment-indicator ${source.SentimentAnalytics.toLowerCase()}`))
                                .append($("<div>").addClass("response-text").append(source.ResponseText))
                            );
                        return jqhtml.html();
                    }
                }
            ],
            quickFilter: {
                "Items": [
                    { "Label": resources.Positive, "AjaxParams": { "status": "Positive" } },
                    { "Label": resources.Neutral, "AjaxParams": { "status": "Neutral" } },
                    { "Label": resources.Negative, "AjaxParams": { "status": "Negative" } }
                ]
            },
            localizableTexts: { "All": resources.Total, "Search": resources.SearchOpenEndQuestions },
            allowRowSelection: false,
            displayColumnSelector: false,
            displaySearchBox: true
        });
    }

    updateOpenEndAnswerQuickFilterCounts(dashboardResults.sentiments);
    bindOpenEndQuickFilterClick(resources.Total);
    selectedSentimentCategory = resources.Total;
}

function dashboardLoadResultsConfiguration() {
    dashboardResults.mainSection = $(".analyze-resultsDashboard");
    dashboardResults.questionsSection = $(".v--questionsDashboard", dashboardResults.mainSection);
    dashboardResults.filterSection = $(".v-reportFilter", dashboardResults.mainSection);

    var configurationSection = $(".v-configurationDashboard", dashboardResults.mainSection);
    dashboardResults.reportConfigurationId = $("#ReportConfigurationId", configurationSection).val();
    dashboardResults.language = $("#Language", configurationSection).val();
    language = $("#Language", configurationSection).val();
    dashboardResults.userLanguage = $("#userLanguage", configurationSection).val();
    dashboardResults.surveyLanguages = $("#SurveyLanguages", configurationSection).val();
}

function searchTopicEvent() {
    var inElement = document.getElementById("topicSearch");
    if (inElement)
        inElement.addEventListener("keypress", function (event) {
            if (event.keyCode === 13) {
                event.preventDefault();
                searchTopics();
            }
        });
}

function searchTopics() {
    var input = document.getElementById("topicSearch");
    dashboardResults.topicSearch = input.value;
    var filter = input.value.toUpperCase();
    var table = document.getElementById("topicTable");
    var tr = table.getElementsByTagName("tr");

    for (i = 0; i < tr.length; i++) {
        td = tr[i].getElementsByClassName("topic-name")[0];
        if (td) {
            txtValue = td.textContent || td.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                tr[i].style.display = "";
            } else {
                tr[i].style.display = "none";
            }
        }
    }
    _paq.push(['trackEvent', 'Survey-AdvancedAnalytics-TextAnalysis', 'Dashboard:Search Topics']);
}

function questionClickEventHandler(row, updateConfig, isErrorMessageShow = false) {
    if (dashboardResults.openEndAnswersTable) {
        dashboardResults.openEndAnswersTable.a4datatable("destroy");
        dashboardResults.openEndAnswersTable = null;
    }
    dashboardResults.loadLastSelectedQuestionFlag = false;
    _paq.push(['trackEvent', 'Survey-AdvancedAnalytics-TextAnalysis', 'Dashboard:Initiate Loading']);
    var dashboardExists = row.data("hasDashboard");
    var dashboardStatus = row.data("dashboardStatus");
    var questionHasResponses;
    var questionName = row.data("variableName");
    var variableId = row.data("variableId");
    questionNameDashboard = row.data("name");
    selectedQuestionName = questionName;
    selectedVariableHasTopicAnalysis = row.data("hasTopicAnalysis");
    selectedQuestionId = row.data("sourceKey");
    selectedVariableId = row.data("variableId");
    dashboardResults.selectedTopic = "";
    if ($(".display-selected-wordtopic").hasClass("visibility-show")) {
        $(".display-selected-wordtopic").removeClass("visibility-show");
        $(".display-selected-wordtopic").addClass("visibility-hide");
    }

    if (dashboardStatus === 'InProgress') {
        a4.showErrorMessage(createDashboardResources.DashboardRunningStatus);
        showInitialInstructions();
        $('.instructions')[0].textContent = createDashboardResources.DashboardRunningStatus;
        setCurrentRowSelected(row);
        changeOnDemandUpdateClass();
        return;
    } else if (dashboardStatus === 'Error' && isErrorMessageShow) {
        showInitialInstructions();
        return;
    }
    dashboardResults.selectedQuestionName = questionName;

    if (!dashboardExists || dashboardStatus == 'Error') {
        if (!canCreateDashboards) {
            a4.showErrorMessage(createDashboardResources.CreateDashboardPermissionDenied);
        }
        else {
            checkIfResponsesExistForQuestion(variableId, questionName);
        }
    }
    else {
        if (!canViewDashboards) {
            a4.showErrorMessage(viewDashboardResources.ViewDashboardPermissionDenied);
        }
        else {
            $(".filterIconDiv").removeClass("hideFilterIcon");
            selectCurrentRowAndShowDashboard(row, updateConfig);
            _paq.push(['trackEvent', 'Survey-AdvancedAnalytics-TextAnalysis', 'Dashboard:Complete Loading']);
        }
    }
}

function checkIfResponsesExistForQuestion(variableId, questionName) {
    a4.callServerMethod(a4.getSurveyAction("CheckIfQuestionHasDashboardAndResponse", "AdvancedAnalytics"), {
        variableName: questionName
    }, function (response) {
        switch (response) {
            case 'DataNotAvailable': a4.showErrorMessage(createDashboardResources.DashboardCreationAndRetryError); break;
            case 'AlreadyCreated': $(".h-refreshButton", dashboardResults.questionNavigatorTable).trigger('click');
            case 'CreationInProgress': a4.showErrorMessage(createDashboardResources.QuestionResponsesAnalysisInProgress); break;
            default: a4.showErrorMessage(createDashboardResources.QuestionHasNoResponses); break;
        }
    });
}

function confirmDialog(variableId) {
    var parent = a4.parent();
    var parentModalDialog = parent.modalDialog;
    var allLoadedQuestions = $('tbody>tr', '.h-questionNavigatorDashboard-table');
    var selectedQuestion = null;
    _.find(allLoadedQuestions, function (item) {
        var currentQn = $(item);
        if (currentQn.data("variableId") === variableId) {
            selectedQuestion = currentQn;
            return true;
        }
        return false;
    });
    if (parentModalDialog['data']) {
        selectCurrentRowAndShowDashboard(selectedQuestion, false, parentModalDialog['data']['detectRequired']);
    }
}

function createDashboard() {
    var data = { detectRequired: false };
    modalDialog.close(data);
}

function selectCurrentRowAndShowDashboard(row, updateConfig, hasLanguageDetect = false) {
    setCurrentRowSelected(row);
    changeOnDemandUpdateClass();
    showLoadingAnimation();
    changeRowQuestionDisplay(row, updateConfig, hasLanguageDetect);
}

function setCurrentRowSelected(row) {
    var selectedElements = $(".selected", dashboardResults.questionNavigatorTable);
    if (selectedElements && selectedElements.length > 0) {
        selectedElements[0].className = selectedElements[0].classList[0];
    }
    row.toggleClass("selected");
}

function changeOnDemandUpdateClass() {
    $("#onDemanUpdate").attr("class", "hiden-update on-demand-update")
}

var showWarning = true;
function dashboardBindQuestionNavigator() {
    dashboardResults.questionNavigator = $(".h-questionNavigatorDashboard");
    dashboardResults.questionNavigatorTable = $(".h-questionNavigatorDashboard-table", dashboardResults.questionNavigator).a4datatable({
        ajaxAction: a4.getSurveyAction("GetQuestionsForAdvancedAnalytics", "AdvancedAnalytics"),
        ajaxParams: { "language": dashboardResults.language },

        columns: [
            {
                "Name": "QuestionDefinition",
                "Title": "",
                "Data": function (source, type, val) {
                    var statusIcon = $("<div>").addClass("dashboard-status-icon");
                    if (source['DashboardStatus'] == 'InProgress') {
                        $(statusIcon).append($("<i>")).addClass("loading-icon").append($("<span class='fa fa-circle-o-notch fa-spin fa-fw'></span>"));
                    } else if (source['DashboardStatus'] == 'Error') {
                        $(statusIcon).append($("<i>")).addClass("fa fa-exclamation");
                    }
                    else if (source['HasDashboard']) {
                        $(statusIcon).append($("<i>")).addClass("fa fa-pie-chart");
                        $(statusIcon).append($("<i>")).find("span").remove();
                    }
                    var jqhtml = $("<div>")
                        .append($("<div>").addClass("question h-goToQuestionDashboard")
                            .attr("title", source.Text)
                            .append($(statusIcon))
                            .append($("<div>").addClass("question-labels-container")
                                .append($("<div>").addClass("name").append(source.Name))
                                .append($("<div>").addClass("text").append(source.Text)))
                        );
                    return jqhtml.html();
                }
            }
        ],

        localizableTexts: { "Search": resources.SearchQuestions },
        allowRowSelection: false,
        displayColumnSelector: false,

        rowCreated: function (event, d) {
            if (showWarning === true) {
                $("#renderWarningId").hide();
                showWarning = false;
            }
            var currentRow = $(d.row);
            currentRow.data("id", d.data.Id);
            currentRow.data("sourceKey", d.data.SourceKey);
            currentRow.data("variableId", d.data.Variables[0] ? d.data.Variables[0].SourceKey : 0);
            currentRow.data("variableName", d.data.Variables[0] ? d.data.Variables[0].Name : 0);
            currentRow.data("hasDashboard", d.data.HasDashboard);
            currentRow.data("dashboardStatus", d.data.DashboardStatus);
            currentRow.data("hasSentimentAnalysis", d.data.HasSentimentAnalysis);
            currentRow.data("hasTopicAnalysis", d.data.HasTopicAnalysis);
            currentRow.data("hasLanguageDetection", d.data.HasLanguageRequired);
            currentRow.data("description", d.data.Text);
            currentRow.data("dashboardCreatedDate", d.data.DashboardCreatedDate);
            currentRow.data("name", d.data.Name);
            currentRow.data("position", d.data.Position);
            currentRow.data("type", d.data.Type);
            currentRow.data("hasResponses", d.data.HasResponses);
        },
        customCallback: function () { loadLastSelectedQuestionFromConfig(1); }
    });

    $(".h-refreshButton", dashboardResults.questionNavigatorTable).on("click", function () {
        showInitialInstructions();
    });

    $("input[type=search]", dashboardResults.questionNavigatorTable).on("keyup", function (event) {
        var searchText = $("input[type=search]").val();
        if (event.which === 13 && searchText.length == 0) {
            setTimeout(addBackgroundColor, 95);
        }
    });

    function addBackgroundColor() {
        $('#DataTables_Table_0 tr td').each(function () {
            var row = $(this).parents("tr");
            var lastSelectedQuestion = row.data("variableName");
            if (dashboardResults.selectedQuestionName == lastSelectedQuestion) {
                $(this).parents("tr").addClass("selected");
            }
        });
    }

    $(dashboardResults.questionNavigator).on("click", ".h-goToQuestionDashboard", function (e) {
        var row = $(this).parents("tr");
        document.getElementById("topicSearch").value = "";
        questionClickEventHandler(row, true);
    });

    $(".h-backToTop", dashboardResults.questionNavigator).on("click", function () {
        $('html, body').animate({
            scrollTop: 0
        }, 2000);
    });
}

var questionNameDashboard = "";
var newlyCreatedQuesions = {};

function changeRowQuestionDisplay(row, updateConfig, hasLanguageDetect = false) {
    dashboardResults.mainSection = $(".analyze-results");
    dashboardResults.questionsSection = $(".v-questions", dashboardResults.mainSection);
    dashboardResults.filterSection = $(".v-reportFilter", dashboardResults.mainSection);

    var configurationSection = $(".v-configuration", dashboardResults.mainSection);

    $("#onDemandUpdate").hide();
    filterAnalytics = {};

    // Setting the default frequency for the Sentiment TrendChart when newly showing the dashboard details for the question
    $(".sentiment-trendChart-frequency", $(".sentiment-trendChart")).prop("selectedIndex", 0).val();

    questionNameDashboard = row.data("name");
    selectedQuestionName = row.data("variableName");
    selectedVariableHasTopicAnalysis = row.data("hasTopicAnalysis");
    selectedQuestionId = row.data("sourceKey");
    selectedVariableId = row.data("variableId");
    selectedQuestionLanguage = $("#Language", configurationSection).val();;
    selectedQuestionText = row.data("description");
    dashboardCreationDate = row.data("dashboardCreatedDate");
    selectedQuestionHasLanguageDetection = row.data("hasLanguageDetection");
    selectedQuestionHasTopicsEnabled = row.data('hasTopicAnalysis');

    var key = row.data("hasDashboard");
    var dashboardStatus = row.data("dashboardStatus");
    var status = resources.CreateDashboard;
    key = '' + key;
    if (dashboardStatus && dashboardStatus === 'UpdateInProgress') {
        a4.showErrorMessage(createDashboardResources.DashboardRunningStatus);
    }
    if (dashboardStatus === 'Error') {
        key = 'false';
    }

    if (dashboardStatus && dashboardStatus === 'InProgress') {
        a4.showErrorMessage(createDashboardResources.DashboardRunningStatus);
        showInitialInstructions();
        $('.instructions')[0].textContent = createDashboardResources.DashboardRunningStatus;
        return;
    }
    else if (key == 'true' || (dashboardStatus !== "NotCreated" && newlyCreatedQuesions[selectedQuestionName] && dashboardStatus != 'Error')) {
        newlyCreatedQuesions[selectedQuestionName] = true;
        status = resources.LoadDashboard;
        key = "true";
    }
    else if (key == 'false') {
        newlyCreatedQuesions[selectedQuestionName] = false;
        key = "false";
    }
    showLoader(status);
    $("#onDemandUpdate .dropdown-toggle").addClass("disabled");
    $("#onDemandUpdate .dropdown-toggle").attr("title", viewDashboardResources.DashboardNoResponseUpdateStatus);

    // If Dashboard is already available
    if (key == 'true') {
        a4.callServerMethod(a4.getSurveyAction("GetSentimentAnalysisGridResults", "AdvancedAnalytics"), {
            variableId: row.data("variableId"),
            "questionName": selectedQuestionName,
            "topicName": dashboardResults.selectedTopic,
            "filterAnalytics": filterAnalytics,
            "updateConfig": updateConfig
        }, function (response) {
            hideLoader();
            getFilterData(response['FilterAnalytics'], true);

            dashboardCreationDate = response['UpdatedDateTime'];
            setDashboardInfo(questionNameDashboard, dashboardCreationDate);

            // if ever no responses are getting fetched while having existing dashboard opened
            if (response.Sentiment.length == 0) {
                let hasFilterApplied = filterAnalytics.Id > 0;
                if (!hasFilterApplied) {
                    $(".dashboard-status-icon", row).removeClass("fa fa-pie-chart");
                    $(".dashboard-status-icon", row).find("span").remove();
                    row.toggleClass("selected");
                    row.data("hasDashboard", false);
                    row.data("dashboardStatus", "NotCreated");
                    row.data("hasResponses", false);
                    a4.showErrorMessage(createDashboardResources.QuestionHasNoResponses);

                    a4.callServerMethod(a4.getSurveyAction("UpdateDashboardStatus", "AdvancedAnalytics"), {
                        questionName: selectedQuestionName,
                        isDashboardCreated: true,
                        status: "NotCreated"
                    });
                }
                else {
                    a4.showErrorMessage(filterErrorsResources.FilterHasNoResponses);
                }
                showInitialInstructions();
                return;
            }
            var hasSentimentAnalysis = row.data("hasSentimentAnalysis");

            if (hasSentimentAnalysis) {
                isUpdateAvailable(row.data("variableName"), row.data("variableId"), row.data('hasTopicAnalysis'), response['BatchUpdate'], response['TopicBatchStatus']);
            }
            if (response.hasOwnProperty("success") && response.success == false) {
                a4.showErrorMessage(createDashboardResources.CreateDashboardLimitReached);
            }
            else {
                if (!newlyCreatedQuesions[row.data("variableName")]) {
                    $(".dashboard-status-icon", row).addClass("fa fa-pie-chart");
                    row.data("hasDashboard", true);
                    row.data("dashboardStatus", "Completed");
                }

                newlyCreatedQuesions[row.data("variableName")] = true;
                $("#onDemandUpdate").show();

                renderPieChart(response['Sentiment']);
                generateCloud(response['Text'], response['WordCloudConfig']);
                showDashboard();

                // Handle topics table
                if (!selectedQuestionHasTopicsEnabled) {
                    $("#topicTableSection").attr("style", "display:none");
                } else {
                    $("#topicTableSection").attr("style", "display:block");
                    if (response['TopicBatchStatus'] === 'BatchUpdateInProgress' || (response['TopicBatchStatus'] === 'BatchUpdateError' && response['Topics'].length == 0)) {
                        $("#topicSearchSection").attr("style", "display:none");
                        $("#topicHeaderControl").attr("style", "display:none");
                        $("#topicTable").empty("");
                        $("#topicTable").append($("<span>").addClass("topic-update-message").text(response['TopicBatchStatus'] === 'BatchUpdateInProgress' ? resources.TopicBatchInProgress : resources.TopicBatchError));
                    } else if (response['TopicBatchStatus'] === 'BatchUpdateError' && response['Topics'].length > 0) {
                        a4.showErrorMessage(createDashboardResources.ErrorAnalysingTopicsNeedtoReenableAgain);

                        $("#topicSearchSection").attr("style", "display:flex");
                        $("#topicHeaderControl").attr("style", "display:flex");

                        generateTopicTable(response['Topics']);
                    }
                    else {
                        if (response['Topics'].length > 0) {
                            $("#topicSearchSection").attr("style", "display:flex");
                            $("#topicHeaderControl").attr("style", "display:flex");

                            generateTopicTable(response['Topics']);
                        } else {
                            $("#topicSearchSection").attr("style", "display:none");
                            $("#topicHeaderControl").attr("style", "display:none");
                            $("#topicTable").empty("");
                            $("#topicTable").append($("<span>").addClass("topic-update-message").text(resources.TopicBatchNoTopics));
                        }
                    }
                }

                if (response['ColorScheme']['PositiveColor'] && response['ColorScheme']['PositiveColor'] != '' && response['ColorScheme']['PositiveColor'] != null) {
                    setColorPickerValues(response['ColorScheme']['PositiveColor'], response['ColorScheme']['NeutralColor'], response['ColorScheme']['NegativeColor']);
                }
                sentiments = response['Sentiment'];
                dashboardResults.sentiments = response['Sentiment'];
                openEndAnswer(row.data("variableId"));

                let frequencyOption = $(".sentiment-trendChart-frequency", $(".sentiment-trendChart")).val();
                renderSentimentTrendChart(response['SentimentTrendData'], response['ColorScheme'], filterAnalytics.SentimentType, frequencyOption);
            }
        });
    }
    else if (key == 'false') {//Construct the dashboard if it is not available
        a4.showErrorMessage(createDashboardResources.QuestionHasNoResponses);
    }
}
function isUpdateAvailable(questionName, variableId, hasTopicAnalysis, batchUpdate = "", topicBatchUpdate = "") {
    if (batchUpdate === "BatchUpdateInProgress" || topicBatchUpdate === "BatchUpdateInProgress") {
        return;
    }
    a4.callServerMethod(a4.getSurveyAction("IsCreateOrUpdateAvailable", "AdvancedAnalytics"), {
        questionName: questionName,
        hasTopicAnalysis: hasTopicAnalysis

    }, function (response) {
        if (response) {
            showUpdate();
        }
    });
}

function showUpdate() {
    a4.showSuccessMessage(viewDashboardResources.DashboardUpdateAvailable);
    $("#onDemandUpdate .dropdown-toggle").removeClass("disabled");
    $("#onDemandUpdate .dropdown-toggle").attr("title", "");
}

function setDashboardInfo(dashboardName, updatedDate) {
    $(".dashboard-name").text(dashboardName);
    $(".dashboard-updated-date .updated-date").text(updatedDate);
}

function updateOpenEndAnswerQuickFilterCounts(sentiments) {
    var positive = getSentimentCountByCategory(sentiments, resources.Positive);
    var negative = getSentimentCountByCategory(sentiments, resources.Negative);
    var neutral = getSentimentCountByCategory(sentiments, resources.Neutral);
    var total = positive + negative + neutral;

    // set the count of open-end answers for each quick filter button
    var quickFilterBar = $(".open-end-answers-quick-filter-bar", dashboardResults.openEndAnswers);
    $(".count-all", $(".quick-filter-all", quickFilterBar)).text(total);
    $(".count-positive", $(".quick-filter-positive", quickFilterBar)).text(positive);
    $(".count-negative", $(".quick-filter-negative", quickFilterBar)).text(negative);
    $(".count-neutral", $(".quick-filter-neutral", quickFilterBar)).text(neutral);
}

function updateOpenEndAnswerQuickFilterWithCounts(positiveCount, negativeCount, neutralCount, colorScheme) {

    // set the count of open-end answers for each quick filter button
    var quickFilterBar = $(".open-end-answers-quick-filter-bar", dashboardResults.openEndAnswers);
    $(".count-all", $(".quick-filter-all", quickFilterBar)).text(((+neutralCount) + (+positiveCount) + (+negativeCount)));
    $(".count-positive", $(".quick-filter-positive", quickFilterBar)).text(positiveCount).attr("style", "color:" + colorScheme['PositiveColor']);
    $(".count-negative", $(".quick-filter-negative", quickFilterBar)).text(negativeCount).attr("style", "color:" + colorScheme['NegativeColor']);
    $(".count-neutral", $(".quick-filter-neutral", quickFilterBar)).text(neutralCount).attr("style", "color:" + colorScheme['NeutralColor']);
}

function getSentimentCountByCategory(sentimentCounts, category) {
    var count = sentimentCounts
        .filter(function (sentimentCount) { return sentimentCount.Category == category })
        .reduce(function (counter, sentimentCount) { return counter + sentimentCount.Value }, 0);
    return count;
}
var selectedSentimentCategory = "";
function bindOpenEndQuickFilterClick(selectedCategory = "") {

    var quickFilterBar = $(".open-end-answers-quick-filter-bar", dashboardResults.openEndAnswers);
    var quickFilterButtons = $(".quick-filter", quickFilterBar);

    $(quickFilterButtons).on("click", function () {
        var sentimentCategory = $("label", $(this)).text();
        selectedSentimentCategory = sentimentCategory;
        filterOpenEndAnswers(sentimentCategory);
    });
    if (selectedCategory !== "") {
        filterOpenEndAnswers(selectedCategory);
    }
}

function filterOpenEndAnswers(sentimentCategory) {
    var quickFilterBar = $(".open-end-answers-quick-filter-bar", dashboardResults.openEndAnswers);
    var quickFilterButtons = $(".quick-filter", quickFilterBar);

    // add "selected" class to the appropriate custom quick filter button
    $(quickFilterButtons).removeClass("selected");
    $("label", quickFilterButtons).filter(function () {
        return $(this).text().startsWith(sentimentCategory);
    }).closest(".quick-filter")
        .addClass("selected");

    // click the default quick filter in the open-end answers datatable
    $(".button.v-quickFilterButton", dashboardResults.openEndAnswersTable)
        .filter(function (index) {
            var quickFilterLabel = $(this).text();
            return quickFilterLabel.startsWith(sentimentCategory)
        })
        .trigger('click');
}

$(document).on("click", "#displayWidgetsForSelectedTopic", function (e) {
    var checkBoxIsChecked = $(this).is(':checked');
    var checkBoxClass = "." + $(this).attr('class') + "";
    var topicName = $(this).attr('data');

    if (checkBoxIsChecked) {
        $('input:checkbox').each(function () {
            this.checked = false;
            $('#topicTable tr').removeAttr('style');
        });

        if ($("#editTopicGlobalTracker").val() === "true") {
            refreshTopicTableAfterEdit(function () {
                $(checkBoxClass).prop('checked', true);
                $(checkBoxClass).closest('tr').attr('style', 'background-color: #43B17B');
                dashboardResults.selectedTopic = $(checkBoxClass).attr('data');
                $("#editTopicGlobalTracker", document).val("false");
                selectUnselectTopicsResponse();
            });
        } else {
            $(this).prop('checked', true);
            $(this).closest('tr').attr('style', 'background-color: #43B17B');
            dashboardResults.selectedTopic = $(this).attr('data');
            selectUnselectTopicsResponse();
        }
        if ($(".display-selected-wordtopic").hasClass("visibility-hide")) {
            $(".display-selected-wordtopic").removeClass("visibility-hide");
            $(".display-selected-wordtopic").addClass("visibility-show");
        }
        $(".selected-word-topic").text(topicName);
    } else {
        if ($(".display-selected-wordtopic").hasClass("visibility-show")) {
            $(".display-selected-wordtopic").removeClass("visibility-show");
            $(".display-selected-wordtopic").addClass("visibility-hide");
        }
        clearSelectedTopicsFilter();
    }
});

function clearSelectedTopicsFilter() {
    $('input:checkbox').each(function () {
        this.checked = false;
        $('#topicTable tr').removeAttr('style');
    });

    $("#wordsDropdownButton").prop('disabled', false);
    dashboardResults.selectedTopic = "";
    if ($("#editTopicGlobalTracker").val() === "true") {
        refreshTopicTable(false);
        $("#editTopicGlobalTracker", document).val("false");
    }
    selectUnselectTopicsResponse();
}

function refreshTopicTableAfterEdit(onEditTopicSuccess) {
    var params = {
        variableId: $("#variableId").val() > 0 ? $("#variableId").val() : selectedVariableId,
        surveyId: a4.getSurveyId()
    };
    a4.callServerMethod(a4.getSurveyAction("GetTopicDataData", "AdvancedAnalytics"), params,
        function (response) {
            generateTopicTable(response['Topics'], false, response['DashboardColorScheme']['PositiveColor'], response['DashboardColorScheme']['NegativeColor'], response['DashboardColorScheme']['NeutralColor'], false);
            if (response['Topics'].length > 0) {
                onEditTopicSuccess();
            }
        });
}

function selectUnselectTopicsResponse() {
    searchTopics();
    a4.callServerMethod(a4.getSurveyAction("GetSentimentAnalysisGridResults", "AdvancedAnalytics"), {
        variableId: selectedVariableId,
        "questionName": selectedQuestionName,
        "topicName": dashboardResults.selectedTopic,
        "filterAnalytics": filterAnalytics
    }, function (response) {
        if (response.Sentiment.length == 0) {
            showInitialInstructions();
            a4.showErrorMessage(filterErrorsResources.FilterHasNoResponses);
            return;
        }
        else {
            renderPieChart(response['Sentiment']);
            generateCloud(response['Text'], response['WordCloudConfig']);
            showDashboard();
            dashboardResults.sentiments = null;
            dashboardResults.sentiments = response['Sentiment'];
            openEndAnswer(selectedVariableId);
            getFilterData(response['FilterAnalytics'], false);
        }
    });
}

function generateTopicTable(topics, hasFullScreen = false, positiveColor = undefined, negativeColor = undefined, neutralColor = undefined, hasEdit = false) {
    var table = $("<table>").addClass("compact dataTable no-footer").addClass("topic-table");

    var selectAllCheckbox = "";
    combinedTopicIds = [];
    if (topics != null && topics.length > 0) {
        if (hasFullScreen || hasEdit) {
            if (hasEdit) {
                selectAllCheckbox = '<th class="icon-column sorting_disabled"><span class="fa fa-fw fa-square-o h-selectAll"></span></th>';
            }

            var thead = '<thead><tr class="header-row">' + selectAllCheckbox + '<th>' + resources.Topic
                + '</th><th> ' + resources.Frequency
                + '</th><th> ' + resources.SentimentPerformance
                + '</th><th>' + resources.Keyword
                + '</th>'
                + '<th></th>'
                + '<th></th></tr></thead>'
            $(table).append(thead);
        }
        for (var index = 0; index < topics.length; index++) {
            var topicId = topics[index]['TopicId'];
            var topicName = topics[index]['TopicName'];
            var variableId = topics[index]['ResponseVariableId'];
            var topicsKeywords = (topics[index]['TopicsKeywords'] === "" || topics[index]['TopicsKeywords'] === null) ? topics[index]['TopicName'] : topics[index]['TopicsKeywords'];
            var positive = topics[index]['Positive'] ? topics[index]['Positive'] : 0;
            var negative = topics[index]['Negative'] ? topics[index]['Negative'] : 0;
            var neutral = topics[index]['Neutral'] ? topics[index]['Neutral'] : 0;
            var total = positive + negative + neutral;
            var iconAndLabel = getTopicType(total);
            var positiveWidthPercentage = (positive / total) * 100 + "%";
            var negativeWidthPercentage = (negative / total) * 100 + "%";
            var neutralWidthPercentage = (neutral / total) * 100 + "%";
            var createCheckBox = $("<input type='checkbox' id='displayWidgetsForSelectedTopic' class='" + topicId + "'>");
            createCheckBox.attr("data", topicsKeywords);
            var row = "";
            if (hasEdit) {
                row = $("<tr>");
                var selectCell = $("<td>").addClass("icon-column").append("<span onclick='selectTopic(this, false)' data-id='" + topicId + "' data-variableId='" + variableId + "' data-topicsKeywords='" + topicsKeywords + "' class='fa fa-fw selectRow'></span>");
                row.append(selectCell);
            }
            else {
                row = $("<tr>");
            }
            var nameCell = $("<td>").addClass("topic-name").append(topicName);
            var keywordCell = (hasFullScreen || hasEdit) ? $("<td>").addClass("topic-keyword").append(topicsKeywords) : "";
            var typeCell = $("<td>").addClass("topic-type").append(iconAndLabel);
            var addCheckBoxForTopics = "";
            if (!hasFullScreen) {
                addCheckBoxForTopics = $("<td>").append(createCheckBox);
            }
            else {
                addCheckBoxForTopics = $("<td hidden>").append(createCheckBox);
            }
            var editCell;
            var rollbackCombinationCell;
            if (hasEdit) {
                editCell = $("<td onclick='editTopic(this)' class='removePointer'>").append("<span class='fa fa-pencil dis-n'><i></i></span>");
                let keywordList = topicsKeywords.split(",");
                if (keywordList.length > 1) {
                    rollbackCombinationCell = $("<td onclick='rollBackTopicCombination(this)' class='edit-hover-class'>").append("<span class='fa fa-undo dis-n' title='" + resources.RollbackTopicCombinationHeader + "'><i></i></span>");
                    combinedTopicIds.push(topicId);
                } else {
                    rollbackCombinationCell = $("<td class='edit-hover-class'>").append("<span><i></i></span>");
                }
            }
            row.append(addCheckBoxForTopics);
            var progressCell = $("<td>").addClass("topic-progress")
                .append($("<div>").addClass("topic-sentiment-proportions")
                    .append($("<div>").addClass("positive proportion").attr("style", "background:" + positiveColor + ";").attr("title", positive).width(positiveWidthPercentage))
                    .append($("<div>").addClass("neutral proportion").attr("style", "background:" + neutralColor + ";").attr("title", neutral).width(neutralWidthPercentage))
                    .append($("<div>").addClass("negative proportion").attr("style", "background:" + negativeColor + ";").attr("title", negative).width(negativeWidthPercentage)));

            row.append(nameCell)
                .append(typeCell)
                .append(progressCell)
                .append(keywordCell)
                .append(editCell)
                .append(rollbackCombinationCell);
            $(table).append(row);

            $("#topicTable").empty().append(table);
        }
    }
}

function getTopicType(frequencyCount) {
    var frequencyLabel = resources.Rare;
    var iconClass = "fa fa-moon-o";

    if (frequencyCount > 20) {
        iconClass = "fa fa-fire";
        frequencyLabel = resources.Popular;
    }
    else if (frequencyCount > 10) {
        iconClass = "fa fa-sun-o"
        frequencyLabel = resources.Frequent;
    }
    else if (frequencyCount > 5) {
        iconClass = "fa fa-bolt"
        frequencyLabel = resources.Common;
    }

    var iconAndLabel = `<i class='frequency-icon ${iconClass}'></i><span> ${frequencyLabel} <span class='topic-frequency-count'>(${frequencyCount})</span></span>`;
    return iconAndLabel;
}

function generateCloud(text, config = undefined, surveyLanguage = undefined, hasEdit = false, wordCloudId = "wordCloud") {
    if (surveyLanguage !== undefined) {
        dashboardResults.language = surveyLanguage;
    }

    if (text != "") {
        dashboardResults.wordCloudText = text;
        dashboardResults.wordCloudConfig = config;
        var updatedCloudText = text;
        let excludeWords = [];
        if (dashboardResults.language == 'fr') {
            excludeWords = ["null", "a", "à", "ai", "aie", "aient", "aies", "ait", "alors", "alors", "as", "au", "au", "aucun", "aucuns", "aura", "aurai", "auraient", "aurais", "aurait", "auras", "aurez", "auriez", "aurions", "aurons", "auront", "aussi", "aussi", "autre", "autre", "aux", "avaient", "avais", "avait", "avant", "avant", "avec", "avec", "avez", "aviez", "avions", "avoir", "avoir", "avons", "ayant", "ayez", "ayons", "bon", "bon", "ça", "ça", "car", "car", "ce", "ce", "ceci", "cela", "cela", "ces", "ces", "cet", "cette", "ceux", "ceux", "chaque", "chaque", "ci", "ci", "comme", "comme", "comment", "comment", "d", "dans", "dans", "de", "début", "début", "dedans", "dedans", "dehors", "dehors", "depuis", "depuis", "des", "des", "dès", "deux", "devoir", "devrait", "devrait", "devrez", "devriez", "devrions", "devrons", "devront", "dois", "doit", "doit", "donc", "donc", "dos", "dos", "droite", "du", "du", "dù", "elle", "elle", "elles", "elles", "en", "en", "encore", "encore", "es", "essai", "est", "est", "et", "et", "étaient", "étaient", "étais", "était", "étant", "état", "état", "été", "été", "étés", "êtes", "étiez", "étions", "étions", "être", "être", "eu", "eu", "eue", "eues", "eûmes", "eurent", "eus", "eusse", "eussent", "eusses", "eussiez", "eussions", "eut", "eût", "eûtes", "eux", "faire", "fais", "faisez", "fait", "fait", "faites", "faites", "fois", "fois", "font", "font", "force", "fûmes", "furent", "fus", "fusse", "fussent", "fusses", "fussiez", "fussions", "fut", "fût", "fûtes", "haut", "hors", "hors", "ici", "ici", "il", "il", "ils", "ils", "j", "je", "je", "juste", "juste", "l", "la", "la", "là", "là", "le", "le", "les", "les", "leur", "leur", "leurs", "lui", "m", "ma", "ma", "maintenant", "maintenant", "mais", "mais", "me", "même", "même", "mes", "mes", "mien", "moi", "moins", "moins", "mon", "mon", "mot", "mot", "n", "nan", "ne", "ni", "ni", "nom", "nommé", "nommée", "nommés", "nommés", "nos", "notre", "notre", "nous", "nous", "nouveau", "nouveaux", "on", "ont", "ou", "ou", "où", "où", "par", "par", "parce", "parce", "parole", "pas", "pas", "personne", "personnes", "peu", "peu", "peut", "peut", "plupart", "plupart", "pour", "pour", "pourquoi", "pourquoi", "qu", "quand", "quand", "que", "que", "quel", "quel", "quelle", "quelle", "quelles", "quelles", "quels", "quels", "qui", "qui", "sa", "sa", "sans", "sans", "se", "sera", "serai", "seraient", "serais", "serait", "seras", "serez", "seriez", "serions", "serons", "seront", "ses", "ses", "seulement", "seulement", "si", "si", "sien", "sien", "soi", "soient", "sois", "soit", "sommes", "son", "son", "sont", "sont", "sous", "sous", "soyez", "soyez", "soyons", "suis", "sujet", "sujet", "sur", "sur", "t", "ta", "ta", "tandis", "tandis", "te", "tellement", "tellement", "tels", "tels", "tes", "tes", "toi", "ton", "ton", "tous", "tous", "tout", "tout", "très", "très", "trop", "trop", "tu", "tu", "un", "une", "valeur", "voient", "voient", "vois", "voit", "vont", "vont", "vos", "votre", "votre", "vous", "vous", "vu", "vu", "y"];
        }
        else {
            //default exclude words for english
            excludeWords = ["null", "a", "a1", "a2", "a3", "a4", "ab", "able", "able", "about", "about", "above", "above", "abst", "abst", "ac", "accordance", "accordance", "according", "according", "accordingly", "accordingly", "across", "across", "act", "act", "actually", "actually", "ad", "added", "added", "adj", "adj", "ae", "af", "affected", "affected", "affecting", "affecting", "affects", "after", "after", "afterwards", "afterwards", "ag", "again", "again", "against", "against", "ah", "ah", "ain", "ain't", "aj", "al", "all", "all", "allow", "allow", "allows", "allows", "almost", "almost", "alone", "alone", "along", "along", "already", "already", "also", "also", "although", "although", "always", "always", "am", "am", "among", "among", "amongst", "amongst", "amoungst", "amount", "an", "an", "and", "and", "announce", "announce", "another", "another", "any", "any", "anybody", "anybody", "anyhow", "anyhow", "anymore", "anymore", "anyone", "anyone", "anything", "anyway", "anyway", "anyways", "anyways", "anywhere", "anywhere", "ao", "ap", "apart", "apart", "apparently", "apparently", "appear", "appreciate", "appreciate", "appropriate", "approximately", "approximately", "ar", "are", "are", "aren", "aren", "arent", "arent", "aren't", "arise", "arise", "around", "around", "as", "as", "a's", "aside", "aside", "ask", "ask", "asking", "asking", "associated", "at", "at", "au", "auth", "auth", "av", "available", "available", "aw", "away", "away", "awfully", "awfully", "ax", "ay", "az", "b", "B", "b", "b1", "b2", "b3", "ba", "back", "back", "bc", "bd", "be", "be", "became", "became", "because", "become", "becomes", "becoming", "been", "been", "before", "before", "beforehand", "beforehand", "begin", "beginning", "beginnings", "beginnings", "begins", "behind", "behind", "being", "believe", "below", "below", "beside", "beside", "besides", "besides", "best", "best", "better", "between", "between", "beyond", "beyond", "bi", "bill", "biol", "biol", "bj", "bk", "bl", "bn", "both", "both", "bottom", "bp", "br", "brief", "brief", "briefly", "briefly", "bs", "bt", "bu", "but", "but", "bx", "by", "by", "c", "C", "c", "c1", "c2", "c3", "ca", "ca", "call", "came", "came", "can", "can", "cannot", "cannot", "cant", "cant", "can't", "cause", "causes", "cc", "cd", "ce", "certain", "certain", "certainly", "certainly", "cf", "cg", "ch", "changes", "ci", "cit", "cj", "cl", "clearly", "clearly", "cm", "c'mon", "cn", "co", "co", "com", "com", "come", "come", "comes", "comes", "con", "concerning", "concerning", "consequently", "consequently", "consider", "consider", "considering", "considering", "contain", "containing", "contains", "corresponding", "could", "could", "couldn", "couldnt", "couldnt", "couldn't", "course", "course", "cp", "cq", "cr", "cry", "cs", "c's", "ct", "cu", "currently", "cv", "cx", "cy", "cz", "d", "D", "d", "d2", "da", "date", "date", "dc", "dd", "de", "definitely", "definitely", "describe", "described", "described", "despite", "despite", "detail", "df", "di", "did", "did", "didn", "didn't", "different", "dj", "dk", "dl", "do", "do", "does", "does", "doesn", "doesn't", "doing", "doing", "don", "done", "done", "don't", "down", "down", "downwards", "downwards", "dp", "dr", "ds", "dt", "du", "due", "due", "during", "during", "dx", "dy", "e", "E", "e", "e2", "e3", "ea", "each", "each", "ec", "ed", "ed", "edu", "edu", "ee", "ef", "effect", "eg", "eg", "ei", "eight", "eight", "eighty", "eighty", "either", "either", "ej", "el", "eleven", "else", "else", "elsewhere", "elsewhere", "em", "en", "end", "end", "ending", "ending", "enough", "enough", "entirely", "entirely", "eo", "ep", "eq", "er", "es", "especially", "especially", "est", "et", "et", "et-al", "et-al", "etc", "etc", "eu", "ev", "even", "even", "ever", "ever", "every", "every", "everybody", "everybody", "everyone", "everyone", "everything", "everything", "everywhere", "everywhere", "ex", "ex", "exactly", "exactly", "example", "example", "except", "except", "ey", "f", "F", "f", "f2", "fa", "far", "far", "fc", "few", "few", "ff", "ff", "fi", "fifteen", "fifth", "fifth", "fify", "fill", "find", "fire", "first", "five", "five", "fix", "fix", "fj", "fl", "fn", "fo", "followed", "followed", "following", "following", "follows", "follows", "for", "for", "former", "former", "formerly", "formerly", "forth", "forth", "forty", "found", "found", "four", "four", "fr", "from", "from", "front", "fs", "ft", "fu", "full", "further", "further", "furthermore", "furthermore", "fy", "g", "G", "g", "ga", "gave", "gave", "ge", "get", "get", "gets", "gets", "getting", "getting", "gi", "give", "give", "given", "given", "gives", "gives", "giving", "giving", "gj", "gl", "go", "go", "goes", "goes", "going", "going", "gone", "gone", "got", "got", "gotten", "gotten", "gr", "greetings", "greetings", "gs", "gy", "h", "H", "h", "h2", "h3", "had", "had", "hadn", "hadn't", "happens", "happens", "hardly", "hardly", "has", "has", "hasn", "hasnt", "hasn't", "have", "have", "haven", "haven't", "having", "having", "he", "he", "hed", "hed", "he'd", "he'll", "hello", "hello", "help", "help", "hence", "hence", "her", "here", "here", "hereafter", "hereafter", "hereby", "hereby", "herein", "herein", "heres", "heres", "here's", "hereupon", "hereupon", "hers", "herself", "hes", "hes", "he's", "hh", "hi", "hi", "hid", "hid", "him", "himself", "his", "hither", "hither", "hj", "ho", "home", "hopefully", "hopefully", "how", "how", "howbeit", "howbeit", "however", "however", "how's", "hr", "hs", "http", "hu", "hundred", "hundred", "hy", "i", "I", "i2", "i3", "i4", "i6", "i7", "i8", "ia", "ib", "ibid", "ic", "id", "id", "i'd", "ie", "ie", "if", "if", "ig", "ignored", "ignored", "ih", "ii", "ij", "il", "i'll", "im", "im", "i'm", "immediate", "immediately", "immediately", "importance", "important", "in", "in", "inasmuch", "inasmuch", "inc", "inc", "indeed", "indeed", "index", "index", "indicate", "indicate", "indicated", "indicated", "indicates", "indicates", "information", "information", "inner", "inner", "insofar", "insofar", "instead", "instead", "interest", "into", "into", "invention", "inward", "inward", "io", "ip", "iq", "ir", "is", "is", "isn", "isn't", "it", "it", "itd", "itd", "it'd", "it'll", "its", "its", "it's", "itself", "iv", "i've", "ix", "iy", "iz", "j", "J", "j", "jj", "jr", "js", "jt", "ju", "just", "just", "k", "K", "k", "ke", "keep", "keep", "keeps", "keeps", "kept", "kept", "kg", "kg", "kj", "km", "km", "know", "known", "knows", "ko", "l", "L", "l", "l2", "la", "largely", "largely", "last", "last", "lately", "lately", "later", "later", "latter", "latter", "latterly", "latterly", "lb", "lc", "le", "least", "least", "les", "less", "less", "lest", "lest", "let", "let", "lets", "lets", "let's", "lf", "like", "like", "liked", "liked", "likely", "likely", "line", "line", "little", "little", "lj", "ll", "'ll", "ln", "lo", "look", "look", "looking", "looking", "looks", "looks", "los", "lr", "ls", "lt", "ltd", "ltd", "m", "M", "m", "m2", "ma", "made", "made", "mainly", "mainly", "make", "make", "makes", "makes", "many", "many", "may", "may", "maybe", "maybe", "me", "me", "mean", "means", "meantime", "meantime", "meanwhile", "meanwhile", "merely", "merely", "mg", "mg", "might", "might", "mightn", "mill", "million", "million", "mine", "miss", "miss", "ml", "ml", "mn", "mo", "more", "more", "moreover", "moreover", "most", "most", "mostly", "mostly", "move", "mr", "mr", "mrs", "mrs", "ms", "mt", "mu", "much", "much", "mug", "mug", "must", "must", "mustn", "mustn't", "my", "my", "myself", "n", "N", "n", "n2", "na", "na", "name", "name", "namely", "namely", "nan", "nay", "nay", "nc", "nd", "nd", "ne", "near", "near", "nearly", "nearly", "necessarily", "necessarily", "necessary", "need", "needs", "neither", "neither", "never", "nevertheless", "nevertheless", "new", "new", "next", "next", "ng", "ni", "nine", "nine", "ninety", "ninety", "nj", "nl", "nn", "no", "no", "nobody", "nobody", "non", "non", "none", "none", "nonetheless", "nonetheless", "noone", "noone", "nor", "nor", "normally", "normally", "nos", "nos", "not", "not", "noted", "noted", "nothing", "novel", "novel", "now", "now", "nowhere", "nowhere", "nr", "ns", "nt", "ny", "o", "O", "o", "oa", "ob", "obtain", "obtain", "obtained", "obtained", "obviously", "obviously", "oc", "od", "of", "of", "off", "off", "often", "often", "og", "oh", "oh", "oi", "oj", "ok", "ok", "okay", "okay", "ol", "old", "old", "om", "omitted", "omitted", "on", "on", "once", "once", "one", "one", "ones", "ones", "only", "only", "onto", "onto", "oo", "op", "oq", "or", "or", "ord", "ord", "os", "ot", "other", "others", "otherwise", "otherwise", "ou", "ought", "ought", "our", "our", "ours", "ourselves", "out", "out", "outside", "outside", "over", "over", "overall", "overall", "ow", "owing", "owing", "own", "own", "ox", "oz", "p", "P", "p", "p1", "p2", "p3", "page", "page", "pagecount", "pages", "pages", "par", "part", "part", "particular", "particular", "particularly", "particularly", "pas", "past", "past", "pc", "pd", "pe", "per", "per", "perhaps", "perhaps", "pf", "ph", "pi", "pj", "pk", "pl", "placed", "placed", "please", "please", "plus", "plus", "pm", "pn", "po", "poorly", "poorly", "possible", "possibly", "potentially", "pp", "pp", "pq", "pr", "predominantly", "predominantly", "present", "presumably", "presumably", "previously", "previously", "primarily", "primarily", "probably", "probably", "promptly", "promptly", "proud", "proud", "provides", "provides", "ps", "pt", "pu", "put", "put", "py", "q", "Q", "q", "qj", "qu", "que", "que", "quickly", "quickly", "quite", "quite", "qv", "qv", "r", "R", "r", "r2", "ra", "ran", "ran", "rather", "rather", "rc", "rd", "rd", "re", "re", "readily", "readily", "really", "really", "reasonably", "reasonably", "recent", "recent", "recently", "recently", "ref", "ref", "refs", "refs", "regarding", "regarding", "regardless", "regardless", "regards", "regards", "related", "related", "relatively", "relatively", "research", "research-articl", "respectively", "respectively", "resulted", "resulted", "resulting", "resulting", "results", "results", "rf", "rh", "ri", "right", "right", "rj", "rl", "rm", "rn", "ro", "rq", "rr", "rs", "rt", "ru", "run", "run", "rv", "ry", "s", "S", "s", "s2", "sa", "said", "said", "same", "saw", "saw", "say", "say", "saying", "saying", "says", "says", "sc", "sd", "se", "sec", "sec", "second", "second", "secondly", "secondly", "section", "section", "see", "seeing", "seem", "seem", "seemed", "seemed", "seeming", "seeming", "seems", "seems", "seen", "seen", "self", "selves", "sensible", "sent", "sent", "serious", "seriously", "seven", "seven", "several", "several", "sf", "shall", "shall", "shan", "shan't", "she", "shed", "shed", "she'd", "she'll", "shes", "shes", "she's", "should", "shouldn't", "show", "show", "showed", "showed", "shown", "shown", "showns", "showns", "shows", "shows", "si", "side", "significant", "significantly", "similar", "similarly", "since", "since", "sincere", "six", "six", "sixty", "sj", "sl", "slightly", "slightly", "sm", "sn", "so", "so", "some", "some", "somebody", "somehow", "somehow", "someone", "somethan", "somethan", "something", "sometime", "sometime", "sometimes", "sometimes", "somewhat", "somewhat", "somewhere", "somewhere", "soon", "soon", "sorry", "sorry", "sp", "specifically", "specifically", "specified", "specified", "specify", "specify", "specifying", "specifying", "sq", "sr", "ss", "st", "still", "still", "stop", "stop", "strongly", "strongly", "sub", "sub", "substantially", "substantially", "successfully", "successfully", "such", "such", "sufficiently", "sufficiently", "suggest", "suggest", "sup", "sup", "sure", "sure", "sy", "sz", "t", "T", "t", "t1", "t2", "t3", "take", "take", "taken", "taken", "taking", "taking", "tb", "tc", "td", "te", "tell", "tell", "ten", "tends", "tends", "tf", "th", "th", "than", "than", "thank", "thank", "thanks", "thanks", "thanx", "thanx", "that", "that", "that'll", "thats", "thats", "that's", "that've", "the", "the", "their", "their", "theirs", "theirs", "them", "them", "themselves", "themselves", "then", "then", "thence", "thence", "there", "there", "thereafter", "thereafter", "thereby", "thereby", "thered", "thered", "therefore", "therefore", "therein", "therein", "there'll", "thereof", "thereof", "therere", "therere", "theres", "theres", "there's", "thereto", "thereto", "thereupon", "thereupon", "there've", "these", "these", "they", "they", "theyd", "theyd", "they'd", "they'll", "theyre", "theyre", "they're", "they've", "thickv", "thin", "think", "think", "third", "third", "this", "this", "thorough", "thorough", "thoroughly", "thoroughly", "those", "those", "thou", "thou", "though", "though", "thoughh", "thoughh", "thousand", "thousand", "three", "three", "throug", "throug", "through", "through", "throughout", "throughout", "thru", "thru", "thus", "thus", "ti", "til", "til", "tip", "tip", "tj", "tl", "tm", "tn", "to", "to", "together", "together", "too", "too", "took", "took", "top", "toward", "toward", "towards", "towards", "tp", "tq", "tr", "tried", "tried", "tries", "tries", "truly", "truly", "try", "try", "trying", "trying", "ts", "ts", "t's", "tt", "tv", "twelve", "twenty", "twice", "twice", "two", "two", "tx", "u", "U", "u", "u201d", "ue", "ui", "uj", "uk", "um", "un", "un", "under", "under", "unfortunately", "unfortunately", "unless", "unless", "unlike", "unlike", "unlikely", "unlikely", "until", "until", "unto", "unto", "uo", "up", "up", "upon", "upon", "ups", "ups", "ur", "us", "us", "use", "used", "used", "useful", "useful", "usefully", "usefully", "usefulness", "usefulness", "uses", "using", "using", "usually", "usually", "ut", "v", "V", "v", "va", "value", "various", "various", "vd", "ve", "'ve", "very", "very", "via", "via", "viz", "viz", "vj", "vo", "vol", "vol", "vols", "vols", "volumtype", "vq", "vs", "vs", "vt", "vu", "w", "W", "w", "wa", "want", "wants", "was", "was", "wasn", "wasnt", "wasnt", "wasn't", "way", "way", "we", "we", "wed", "wed", "we'd", "welcome", "welcome", "well", "well", "we'll", "well-b", "went", "went", "were", "were", "we're", "weren", "werent", "werent", "weren't", "we've", "what", "what", "whatever", "whatever", "what'll", "whats", "whats", "what's", "when", "when", "whence", "whence", "whenever", "whenever", "when's", "where", "where", "whereafter", "whereafter", "whereas", "whereas", "whereby", "whereby", "wherein", "wherein", "wheres", "wheres", "where's", "whereupon", "whereupon", "wherever", "wherever", "whether", "whether", "which", "which", "while", "while", "whim", "whim", "whither", "whither", "who", "who", "whod", "whod", "whoever", "whoever", "whole", "whole", "who'll", "whom", "whom", "whomever", "whomever", "whos", "whos", "who's", "whose", "whose", "why", "why", "why's", "wi", "widely", "widely", "will", "willing", "wish", "with", "with", "within", "within", "without", "without", "wo", "won", "wonder", "wonder", "wont", "wont", "won't", "words", "world", "would", "would", "wouldn", "wouldnt", "wouldnt", "wouldn't", "www", "www", "x", "X", "x", "x1", "x2", "x3", "xf", "xi", "xj", "xk", "xl", "xn", "xo", "xs", "xt", "xv", "xx", "y", "Y", "y", "y2", "yes", "yes", "yet", "yet", "yj", "yl", "you", "you", "youd", "youd", "you'd", "you'll", "your", "your", "youre", "youre", "you're", "yours", "yours", "yourself", "yourselves", "you've", "yr", "ys", "yt", "z", "Z", "z", "zero", "zero", "zi", "zz"]
        }

        if (config && config['StopWords'] && config['StopWords'] !== "" && config['StopWords'] !== " ") {
            excludeWords = [...excludeWords, ...config['StopWords'].split(",")];
            var stopWordsList = config['StopWords'].split(",");
            for (var i = 0; i < stopWordsList.length; i++) {
                if (stopWordsList[i] != "") {
                    var regEx = new RegExp("\\b(?:" + stopWordsList[i] + ")\\b", "gi");
                    updatedCloudText = updatedCloudText.replace(regEx, " ");
                }
            }
        }
        if (config && config['Theme'] && config['Theme'] !== 'Custom') {
            switch (config['Theme']) {
                case 'dataviz':
                    am4core.useTheme(am4themes_dataviz);
                    break;
                case 'kellys':
                    am4core.useTheme(am4themes_kelly);
                    break;
                case 'material':
                    am4core.useTheme(am4themes_material);
                    break;
                case 'frozen':
                    am4core.useTheme(am4themes_frozen);
                    break;
                case 'moonriseKingdom':
                    am4core.useTheme(am4themes_moonrisekingdom);
                    break;
                case 'spritedAway':
                    am4core.useTheme(am4themes_spiritedaway);
                    break;
            }
        }

        let chart = am4core.create(wordCloudId, am4plugins_wordCloud.WordCloud);
        let series = chart.series.push(new am4plugins_wordCloud.WordCloudSeries());

        if (config && config['WordLimit'] > 0) {
            series.maxCount = config['WordLimit'];
        } else {
            if (config && config['WordLimit'] == -1) {
            } else {
                series.maxCount = 100;
            }
        }

        if (config && config['Direction']) {
            var directions = config['Direction'].split(",");
            if (directions[0] === 'true' && directions[1] === 'true') {
                series.rotationThreshold = 0.7;
                series.angles = [0, -90];
            } else if (directions[0] === 'true') {
                series.angles = [0];
            } else if (directions[1] === 'true') {
                series.angles = [90];
            }
        } else {
            series.rotationThreshold = 0.7;
            series.angles = [0, -90];
        }
        series.labels.template.tooltipText = "{word}: {value}";

        if (config && config['Font']) {
            series.fontFamily = config['Font'];
        }
        series.excludeWords = excludeWords;
        series.maxFontSize = am4core.percent(30);
        series.text = updatedCloudText;
        series.colors = new am4core.ColorSet();
        series.colors.passOptions = {};
        series.colors.reuse = true;

        if (hasEdit) {
            series.labels.template.events.on('doublehit', (ev) => {
                renderStopWord(ev.target.dataItem.dataContext['word']);
            });
            series.labels.template.events.on('hit', (ev) => {
                renderStopWord(ev.target.dataItem.dataContext['word']);
            });
        }
        if (!config || !config['Theme']) {
            series.colors.list = [
                am4core.color("#15465B"),
                am4core.color("#0B5677"),
                am4core.color("#0076A9")
            ];
        }
        if (config && config['Theme'] == 'Custom') {
            var colors = config["ThemeColors"].split(",");
            var colorArray = [];
            for (var color of colors) {
                colorArray.push(am4core.color(color));
            }
            series.colors.list = colorArray
        }
        if (config && config['Theme'] && config['Theme'] !== 'Custom') {
            switch (config['Theme']) {
                case 'dataviz':
                    am4core.unuseTheme(am4themes_dataviz);
                    break;
                case 'kellys':
                    am4core.unuseTheme(am4themes_kelly);
                    break;
                case 'material':
                    am4core.unuseTheme(am4themes_material);
                    break;
                case 'frozen':
                    am4core.unuseTheme(am4themes_frozen);
                    break;
                case 'moonriseKingdom':
                    am4core.unuseTheme(am4themes_moonrisekingdom);
                    break;
                case 'spritedAway':
                    am4core.unuseTheme(am4themes_spiritedaway);
                    break;
            }
        }
    }
}

function compare(a, b) {
    var aTotal = (a['Positive'] ? a['Positive'] : 0) + (a['Negative'] ? a['Negative'] : 0) + (a['Neutral'] ? a['Neutral'] : 0)
    var bTotal = (b['Positive'] ? b['Positive'] : 0) + (b['Negative'] ? b['Negative'] : 0) + (b['Neutral'] ? b['Neutral'] : 0)

    if (aTotal < bTotal) {
        return -1;
    }
    if (aTotal > bTotal) {
        return 1;
    }
    return 0;
}

var series;
var chart;
function updateChartColor(data) {
    if (chart.data) {
        chart.data = data;
    }
}
function renderPieChart(data, showSentimentEmoji = false, chartRadius = 95, innerRadius = 60, legendRequired = true, legendPosition = "bottom", legendFontSize = 11, legendValueFontSize = 12) {
    chart = am4core.create("pieChart", am4charts.PieChart);
    chart.data = data;
    chart.numberFormatter.numberFormat = "#.";

    series = chart.series.push(new am4charts.PieSeries());
    series.dataFields.value = "Value";
    series.dataFields.category = "Category";
    chart.innerRadius = am4core.percent(innerRadius);
    chart.radius = am4core.percent(chartRadius);
    series.labels.template.disabled = true;

    series.slices.template.propertyFields.fill = "Color";
    series.slices.template.propertyFields.isActive = "pulled";
    series.slices.template.events.on("hit", function (ev) {
        var sentimentCategory = ev.target.dataItem.properties.category;
        selectedSentimentCategory = sentimentCategory;
        filterOpenEndAnswers(sentimentCategory);
    });

    if (showSentimentEmoji) {
        // find the Max count
        const maxSentimentObject = data.reduce((prev, current) => (prev.Value > current.Value) ? prev : current)
        var label = series.createChild(am4core.Label);
        label.text = maxSentimentObject.Category;
        label.y = 50;
        label.fontSize = 20;
        label.horizontalCenter = "middle";
        label.verticalCenter = "middle";
        label.fill = maxSentimentObject.Color;

        var marker = series.createChild(am4core.Sprite);
        marker.path = getPathForResponseEmoji(maxSentimentObject.Category);
        marker.horizontalCenter = "middle";
        marker.verticalCenter = "middle";
        marker.fill = maxSentimentObject.Color;
        marker.align = "center";
        marker.valign = "middle";
        marker.resizable = true;
        marker.scale = 0.7;
        marker.y = 0;
    }

    if (legendRequired) {
        chart.legend = new am4charts.Legend();
        chart.legend.markers.template.disabled = true;
        chart.legend.labels.template.text = "[bold {color} font-size:" + legendValueFontSize + "px]{value.percent.formatNumber('#.0')}%[/]\n{name}";
        chart.legend.valueLabels.template.text = "";
        chart.legend.position = legendPosition;
        chart.legend.fontSize = legendFontSize;
        chart.legend.itemContainers.template.clickable = false;
        chart.legend.itemContainers.template.focusable = false;
    }
}

var sentimentTrendPositiveSeries;
var sentimentTrendNeutralSeries;
var sentimentTrendNegativeSeries;

function updateSentimentTrendColors(positiveColor, neutralColor, negativeColor) {
    sentimentTrendPositiveSeries.stroke = am4core.color(positiveColor);
    sentimentTrendNeutralSeries.stroke = am4core.color(neutralColor);
    sentimentTrendNegativeSeries.stroke = am4core.color(negativeColor);
}

function renderSentimentTrendChart(data, colorScheme, filteredSentiment, frequencyOption = 1) {
    let positiveColor = colorScheme.PositiveColor;
    let neutralColor = colorScheme.NeutralColor;
    let negativeColor = colorScheme.NegativeColor;

    dashboardResults.sentimentTrendData = data

    // Create chart instance
    var sentimentTrendChart = am4core.create("sentimentTrendChart", am4charts.XYChart);
    sentimentTrendChart.data = data.SentimentTrendItemList;
    sentimentTrendChart.fontSize = 12;
    sentimentTrendChart.numberFormatter.numberFormat = "#.";

    if (dashboardResults.userLanguage === "fr") {
        sentimentTrendChart.dateFormatter.language = new am4core.Language();
        sentimentTrendChart.dateFormatter.language.locale = am4lang_fr_FR;
    }

    var dateAxis = sentimentTrendChart.xAxes.push(new am4charts.DateAxis());
    dateAxis.renderer.grid.template.location = 0.5;
    dateAxis.fontSize = 11;
    configureChartAxisToolTip(dateAxis);

    switch (frequencyOption) {
        case "2":
            dateAxis.baseInterval = { "timeUnit": "month", "count": 1 };
            dateAxis.periodChangeDateFormats.setKey("month", "MMM yyyy");
            dateAxis.dateFormats.setKey("month", "MMM yyyy");
            dateAxis.tooltipDateFormat = "MMM yyyy";
            break;
        default:
            dateAxis.baseInterval = { "timeUnit": "day", "count": 1 };
            dateAxis.dateFormats.setKey("day", "MMM dd");
            dateAxis.tooltipDateFormat = "yyyy MMM dd";
            break;
    }

    // First value axis
    var valueAxis = sentimentTrendChart.yAxes.push(new am4charts.ValueAxis());
    valueAxis.title.text = resources.Sentiment + " (%)";
    valueAxis.fontSize = 12;
    configureChartAxisToolTip(valueAxis);

    let isSentimentFilterApplied = filteredSentiment !== null && filteredSentiment !== undefined && filteredSentiment !== '';
    var seriesHolder;

    if (!isSentimentFilterApplied || filteredSentiment === 'Positive') {
        // First series
        sentimentTrendPositiveSeries = sentimentTrendChart.series.push(new am4charts.LineSeries());
        sentimentTrendPositiveSeries.dataFields.valueY = "PositivePercentage";
        sentimentTrendPositiveSeries.dataFields.dateX = "Date";
        sentimentTrendPositiveSeries.dataFields.customValue = "PositiveCount";
        sentimentTrendPositiveSeries.name = resources.Positive;
        sentimentTrendPositiveSeries.stroke = am4core.color(positiveColor);
        sentimentTrendPositiveSeries.strokeWidth = 2;
        sentimentTrendPositiveSeries.yAxis = valueAxis;

        seriesHolder = sentimentTrendPositiveSeries;
    }
    if (!isSentimentFilterApplied || filteredSentiment === 'Neutral') {
        // Second series
        sentimentTrendNeutralSeries = sentimentTrendChart.series.push(new am4charts.LineSeries());
        sentimentTrendNeutralSeries.dataFields.valueY = "NeutralPercentage";
        sentimentTrendNeutralSeries.dataFields.dateX = "Date";
        sentimentTrendNeutralSeries.dataFields.customValue = "NeutralCount";
        sentimentTrendNeutralSeries.name = resources.Neutral;
        sentimentTrendNeutralSeries.stroke = am4core.color(neutralColor);
        sentimentTrendNeutralSeries.strokeWidth = 2;
        sentimentTrendNeutralSeries.yAxis = valueAxis;

        seriesHolder = sentimentTrendNeutralSeries;
    }
    if (!isSentimentFilterApplied || filteredSentiment === 'Negative') {
        // Thrid series
        sentimentTrendNegativeSeries = sentimentTrendChart.series.push(new am4charts.LineSeries());
        sentimentTrendNegativeSeries.dataFields.valueY = "NegativePercentage";
        sentimentTrendNegativeSeries.dataFields.dateX = "Date";
        sentimentTrendNegativeSeries.dataFields.customValue = "NegativeCount";
        sentimentTrendNegativeSeries.name = resources.Negative;
        sentimentTrendNegativeSeries.stroke = am4core.color(negativeColor);
        sentimentTrendNegativeSeries.strokeWidth = 2;
        sentimentTrendNegativeSeries.yAxis = valueAxis;

        seriesHolder = sentimentTrendNegativeSeries;
    }

    // Configure Tooltip for all of the serieses
    configureSeriesToolTip(sentimentTrendPositiveSeries);
    configureSeriesToolTip(sentimentTrendNeutralSeries);
    configureSeriesToolTip(sentimentTrendNegativeSeries);

    // Make bullets grow on hover
    var bullet = seriesHolder.bullets.push(new am4charts.CircleBullet());
    bullet.circle.strokeWidth = 1;
    bullet.circle.stroke = am4core.color("#0B5677");
    bullet.circle.radius = 1.5;
    bullet.circle.fill = am4core.color("#0B5677");

    var bullethover = bullet.states.create("hover");
    bullethover.properties.scale = 1.3;

    if (!isSentimentFilterApplied) {
        switch (seriesHolder.name) {
            case resources.Positive:
                sentimentTrendNeutralSeries.bullets.push(bullet);
                sentimentTrendNegativeSeries.bullets.push(bullet);
                break;
            case resources.Neutral:
                sentimentTrendPositiveSeries.bullets.push(bullet);
                sentimentTrendNegativeSeries.bullets.push(bullet);
                break;
            case resources.Negative:
                sentimentTrendPositiveSeries.bullets.push(bullet);
                sentimentTrendNeutralSeries.bullets.push(bullet);
                break;
        }
    }

    // Add legend
    sentimentTrendChart.legend = new am4charts.Legend();
    sentimentTrendChart.legend.fontSize = 11;
    sentimentTrendChart.legend.position = "right";
    sentimentTrendChart.legend.valign = "top";
    sentimentTrendChart.legend.itemContainers.template.paddingBottom = 5;
    sentimentTrendChart.legend.itemContainers.template.paddingRight = 0;
    sentimentTrendChart.legend.maxWidth = 120;
    sentimentTrendChart.legend.itemContainers.template.clickable = false;
    sentimentTrendChart.legend.itemContainers.template.focusable = false;

    // Add cursor
    sentimentTrendChart.cursor = new am4charts.XYCursor();
    sentimentTrendChart.cursor.maxTooltipDistance = 2;
}

function configureSeriesToolTip(series) {
    if (series !== undefined && series !== null) {
        series.tooltipText = series.name + ": [bold]{" + series.dataFields.valueY + "}%[/] ({" + series.dataFields.customValue + "})\n";
        series.tooltip.getFillFromObject = false;
        series.tooltip.background.fill = am4core.color("white");
        series.tooltip.background.stroke = am4core.color("#8C8C8C");
        series.tooltip.fontSize = 11;
        series.tooltip.label.fill = am4core.color("black");
    }
}

function configureChartAxisToolTip(axis) {
    /* Configure axis tooltip */
    var axisTooltip = axis.tooltip;
    axisTooltip.label.fill = am4core.color("black");
    axisTooltip.fontSize = 11;
    axisTooltip.background.fill = am4core.color("white");
    axisTooltip.background.stroke = am4core.color("#8C8C8C");
    axisTooltip.background.cornerRadius = 2;
    axisTooltip.background.pointerLength = 5;
    axisTooltip.dy = 0;

    /* Decorate axis tooltip content */
    axis.adapter.add("getTooltipText", function (text, target) {
        return "[bold]" + text + "[/]";
    });
}

$(".sentiment-trendChart-frequency", $(".sentiment-trendChart")).on("change", function () {

    var frequencyOption = $(".sentiment-trendChart-frequency", $(".sentiment-trendChart")).val();

    a4.callServerMethod(a4.getSurveyAction("GetSentimentTrendData", "AdvancedAnalytics"), {
        variableId: selectedVariableId,
        filterAnalytics: filterAnalytics,
        frequencyOption: frequencyOption
    }, function (response) {
        renderSentimentTrendChart(response['SentimentTrendData'], response['ColorScheme'], filterAnalytics.SentimentType, frequencyOption);
    });
});

function getPathForResponseEmoji(maxRes) {
    var path = "";
    if (maxRes === resources.Negative) {
        path = "M 28.667969 79.410156 C 26.175781 78.511719 24.882812 75.761719 25.777344 73.292969 C 29.265625 63.628906 39.625 57.375 51 57.375 C 62.375 57.375 72.734375 63.628906 76.222656 73.292969 C 77.117188 75.761719 75.824219 78.511719 73.332031 79.410156 C 70.863281 80.304688 68.113281 79.011719 67.214844 76.519531 C 65.382812 71.421875 59.207031 66.9375 51 66.9375 C 42.792969 66.9375 36.617188 71.421875 34.785156 76.519531 C 33.886719 79.011719 31.136719 80.304688 28.667969 79.410156 Z M 41.515625 41.4375 C 41.515625 44.964844 38.648438 47.8125 35.140625 47.8125 C 31.617188 47.8125 28.765625 44.964844 28.765625 41.4375 C 28.765625 37.910156 31.617188 35.0625 35.140625 35.0625 C 38.648438 35.0625 41.515625 37.910156 41.515625 41.4375 Z M 60.640625 41.4375 C 60.640625 37.910156 63.492188 35.0625 67.015625 35.0625 C 70.523438 35.0625 73.390625 37.910156 73.390625 41.4375 C 73.390625 44.964844 70.523438 47.8125 67.015625 47.8125 C 63.492188 47.8125 60.640625 44.964844 60.640625 41.4375 Z M 102 51 C 102 79.167969 79.167969 102 51 102 C 22.832031 102 0 79.167969 0 51 C 0 22.832031 22.832031 0 51 0 C 79.167969 0 102 22.832031 102 51 Z M 51 9.5625 C 28.109375 9.5625 9.5625 28.109375 9.5625 51 C 9.5625 73.890625 28.109375 92.4375 51 92.4375 C 73.890625 92.4375 92.4375 73.890625 92.4375 51 C 92.4375 28.109375 73.890625 9.5625 51 9.5625 Z M 51 9.5625 ";
    }
    else if (maxRes === resources.Positive) {
        path = "M 51 70.125 C 58.410156 70.125 63.589844 66.640625 66.617188 63.371094 C 68.390625 61.4375 71.421875 61.300781 73.371094 63.09375 C 75.304688 64.886719 75.425781 67.914062 73.632812 69.847656 C 69.269531 74.609375 61.699219 79.6875 51 79.6875 C 40.300781 79.6875 32.730469 74.609375 28.367188 69.847656 C 26.574219 67.914062 26.515625 64.886719 28.628906 63.09375 C 30.578125 61.300781 33.609375 61.4375 35.382812 63.371094 C 38.410156 66.640625 43.589844 70.125 51 70.125 Z M 41.515625 41.4375 C 41.515625 44.964844 38.648438 47.8125 35.140625 47.8125 C 31.617188 47.8125 28.765625 44.964844 28.765625 41.4375 C 28.765625 37.910156 31.617188 35.0625 35.140625 35.0625 C 38.648438 35.0625 41.515625 37.910156 41.515625 41.4375 Z M 60.640625 41.4375 C 60.640625 37.910156 63.492188 35.0625 67.015625 35.0625 C 70.523438 35.0625 73.390625 37.910156 73.390625 41.4375 C 73.390625 44.964844 70.523438 47.8125 67.015625 47.8125 C 63.492188 47.8125 60.640625 44.964844 60.640625 41.4375 Z M 102 51 C 102 79.167969 79.167969 102 51 102 C 22.832031 102 0 79.167969 0 51 C 0 22.832031 22.832031 0 51 0 C 79.167969 0 102 22.832031 102 51 Z M 51 9.5625 C 28.109375 9.5625 9.5625 28.109375 9.5625 51 C 9.5625 73.890625 28.109375 92.4375 51 92.4375 C 73.890625 92.4375 92.4375 73.890625 92.4375 51 C 92.4375 28.109375 73.890625 9.5625 51 9.5625 Z M 51 9.5625 ";
    }
    else {
        path = "M 28.765625 41.4375 C 28.765625 37.910156 31.617188 35.0625 35.140625 35.0625 C 38.648438 35.0625 41.515625 37.910156 41.515625 41.4375 C 41.515625 44.964844 38.648438 47.8125 35.140625 47.8125 C 31.617188 47.8125 28.765625 44.964844 28.765625 41.4375 Z M 73.390625 41.4375 C 73.390625 44.964844 70.523438 47.8125 67.015625 47.8125 C 63.492188 47.8125 60.640625 44.964844 60.640625 41.4375 C 60.640625 37.910156 63.492188 35.0625 67.015625 35.0625 C 70.523438 35.0625 73.390625 37.910156 73.390625 41.4375 Z M 65.34375 65.34375 C 67.992188 65.34375 70.125 67.476562 70.125 70.125 C 70.125 72.773438 67.992188 74.90625 65.34375 74.90625 L 36.65625 74.90625 C 34.007812 74.90625 31.875 72.773438 31.875 70.125 C 31.875 67.476562 34.007812 65.34375 36.65625 65.34375 Z M 102 51 C 102 79.167969 79.167969 102 51 102 C 22.832031 102 0 79.167969 0 51 C 0 22.832031 22.832031 0 51 0 C 79.167969 0 102 22.832031 102 51 Z M 51 92.4375 C 73.890625 92.4375 92.4375 73.890625 92.4375 51 C 92.4375 28.109375 73.890625 9.5625 51 9.5625 C 28.109375 9.5625 9.5625 28.109375 9.5625 51 C 9.5625 73.890625 28.109375 92.4375 51 92.4375 Z M 51 92.4375 ";
    }
    return path;
}

function getMaxResponsesSentiment(totalResponses) {
    var filterArray = [totalResponses.positive, totalResponses.negative, totalResponses.neutral];
    var maxCount = Math.max.apply(null, filterArray);
    var sentiment = "";
    if (totalResponses.positive === maxCount) {
        sentiment = resources.Positive;
    }
    else if (totalResponses.neutral === maxCount) {
        sentiment = resources.Neutral;
    }
    else if (totalResponses.negative === maxCount) {
        sentiment = resources.Negative;
    }
    return sentiment;
}

function runOnDemandUpdate() {
    _paq.push(['trackEvent', 'Survey-AdvancedAnalytics-TextAnalysis', 'Dashboard:Run OnDemand Update']);
    showLoader(resources.UpdateDashboard);
    $("#onDemandUpdate .h-newModuleMenu").removeClass("dropdown-container");
    $("#onDemandUpdate .dropdown-toggle").addClass("disabled");
    $("#onDemandUpdate .refresh-button").addClass("disabled");
    $("#onDemandUpdate .export-button").addClass("disabled");
    $("#onDemandUpdate .dropdown-toggle").attr("title", viewDashboardResources.DashboardNoResponseUpdateStatus);

    a4.callServerMethod(a4.getSurveyAction("GetOnDemandDashboardQuestionResults", "AdvancedAnalytics"), {
        questionName: selectedQuestionName,
        variableId: selectedVariableId,
        updatedDate: dashboardCreationDate,
        language: dashboardResults.language,
        hasTopicAnalysis: selectedVariableHasTopicAnalysis,
        hasLanguageDetect: selectedQuestionHasLanguageDetection
    }, function (response) {
        hideLoader();
        $("#onDemandUpdate .export-button").removeClass("disabled");
        $("#onDemandUpdate .refresh-button").removeClass("disabled");
        if (response['Status'] == '508') {
            a4.showErrorMessage(resources.UpdateDashboardNoDataAlert);
            return;
        }

        let hasPermissionIssue = response.hasOwnProperty("createDashboardPermission") && response.createDashboardPermission === false;
        let hasNoValidLicenses = response.hasOwnProperty("hasValidLicenses") && response.hasValidLicenses === false;
        let hasFailedToUpdate = response.hasOwnProperty("success") && response.success === false;

        if (hasPermissionIssue || hasNoValidLicenses || hasFailedToUpdate) {
            if (hasPermissionIssue) {
                a4.showErrorMessage(createDashboardResources.NoPermissionForDashboardUpdate);
            }
            else if (hasNoValidLicenses) {
                a4.showErrorMessage(createDashboardResources.CreateDashboardLimitReached);
            }
            else if (hasFailedToUpdate) {
                a4.showErrorMessage(createDashboardResources.ErrorWhileUpdatingDashboard);
            }
            $("#onDemandUpdate .dropdown-toggle").removeClass("disabled");
            return;
        }

        let isUpdateSucceeded = (response.hasOwnProperty("success") && response.success === true) && (response.hasOwnProperty("status") && response.status === "UpdateInProgress");

        if (response.hasOwnProperty("HasDashboard")) {
            if (!response.HasDashboard) {
                a4.showErrorMessage(resources.UpdateDashboardNoResponses);
                showInitialInstructions();
                var selectedRow = dashboardResults.questionNavigatorTable.find(".selected");
                $(".dashboard-status-icon", selectedRow).removeClass("fa fa-pie-chart");
                $(".dashboard-status-icon", selectedRow).find("span").remove();
                selectedRow.data("hasDashboard", false);
                selectedRow.data("hasResponses", false);
            }
        }
        else if (isUpdateSucceeded) {
            var selectedRow = dashboardResults.questionNavigatorTable.find(".selected");
            $(".dashboard-status-icon", selectedRow).removeClass("fa fa-pie-chart");
            $(".dashboard-status-icon", selectedRow).addClass("loading-icon").addClass("loading-icon").append($("<span class='fa fa-circle-o-notch fa-spin fa-fw'></span>"));
            selectedRow.data("dashboardStatus", "UpdateInProgress");
        }
    });
}

function refreshQuestion(ev) {
    var allLoadedQuestions = $('tbody>tr', '.h-questionNavigatorDashboard-table');
    var selectedQuestion = null;
    _.find(allLoadedQuestions, function (item) {
        var currentQn = $(item);
        if (currentQn.data("variableId") === selectedVariableId) {
            selectedQuestion = currentQn;
            return true;
        }
        return false;
    });
    selectCurrentRowAndShowDashboard(selectedQuestion, false);
}

function onDemandUpdate(ev) {
    if (ev.className.includes("disabled")) {
        return;
    }
    validateRemainingLicenseCount(selectedQuestionName, function () {
        var parent = a4.parent();
        var parentModalDialog = parent.modalDialog;
        if (!selectedQuestionHasLanguageDetection) {
            selectedQuestionHasLanguageDetection = false
        }
        modalDialog.showWindow(a4.getSurveyAction("ConfirmDashboardCreate", "AdvancedAnalytics",
            { type: 'update', hasLanguageDetect: selectedQuestionHasLanguageDetection, surveyLanguages: dashboardResults.surveyLanguages }),
            280, 550, {
            afterClose: function () {
                if (parentModalDialog['data']) {
                    selectedQuestionHasLanguageDetection = parentModalDialog['data']['detectRequired'];
                    runOnDemandUpdate();
                }
            }
        });
    });
}

function validateRemainingLicenseCount(questionName, onSuccess) {
    var parameters = {
        surveyId: a4.getSurveyId,
        questionName: questionName
    };

    var hasRemainingLicenseAction = a4.getAction("HasRemainingLicenseCount", "AdvancedAnalytics", "Survey");
    a4.callServerMethod(hasRemainingLicenseAction, parameters, function (result) {
        if (result == true) {
            onSuccess();
        }
        else {
            a4.showErrorMessage(createDashboardResources.CreateDashboardLimitReached);
        }
    });
}

function showDashboard() {
    $("#initialInstructions").hide();
    $(".dashboard-container").show();
}

function showInitialInstructions() {
    $(".dashboard-container").hide();
    $("#initialInstructions").show();
    $("#onDemandUpdate").hide();
}

function getSentimentPerformance(viewName, hasEdit = false) {
    var height = 800; var width = 800;
    if (viewName.toLowerCase() == "sentimentperformance") {
        height = 500; width = 500;
    }

    var sentimentType = $('.filter-sentimentType :selected').val() == "All" ? "" : $('.filter-sentimentType :selected').val();
    var fromDate = $('.filter-fromDate').val() == "" ? "0001-01-01" : $('.filter-fromDate').val();
    var toDate = $('.filter-toDate').val() == "" ? "0001-01-01" : $('.filter-toDate').val();
    var filterAction = "";
    var filterDTOAnalytics = {};
    filterDTOAnalytics.ResponseFilterJSON = filterAnalytics.ResponseFilterJSON;

    var OptionLastActivityType;
    if ($("#filterDateToday").is(':checked')) {
        OptionLastActivityType = 0;
    } else if ($("#filterDateThisMonth").is(':checked')) {
        OptionLastActivityType = 1;
    }
    else {
        OptionLastActivityType = 2;
    }

    modalDialog.showWindow(a4.getSurveyAction("GetChartData", "AdvancedAnalytics",
        { variableId: selectedVariableId, viewName: viewName, topicName: dashboardResults.selectedTopic, sentimentType: sentimentType, fromDate: fromDate, toDate: toDate, filterAction: filterAction, hasEdit: hasEdit, questionName: selectedQuestionName, questionId: selectedQuestionId, sentimentCategory: selectedSentimentCategory, language: dashboardResults.language, topicSearch: dashboardResults.topicSearch, "responseFilterJSON": filterAnalytics.ResponseFilterJSON, lastActivityType: OptionLastActivityType }),
        height, width, {
        afterClose: function () {
            closewindow(viewName, selectedVariableId, selectedQuestionName);
        }
    });
}

function closewindow(viewName, selectedVariableId, selectedQuestionName) {
    var parent = a4.parent();
    var parentModalDialog = parent.modalDialog;
    if (parentModalDialog.data) {
        if (parentModalDialog.data['View'] && parentModalDialog.data['View'] === 'wordcloud') {
            generateCloud(dashboardResults.wordCloudText, parentModalDialog.data)
        }
        if (parentModalDialog.data['colorScheme']) {
            let positiveColor = parentModalDialog.data['colorScheme']['PositiveColor'];
            let neutralColor = parentModalDialog.data['colorScheme']['NeutralColor'];
            let negativeColor = parentModalDialog.data['colorScheme']['NegativeColor'];

            setColorPickerValues(positiveColor, neutralColor, negativeColor);
            updateChartColor(parentModalDialog.data['data']);
            updateSentimentTrendColors(positiveColor, neutralColor, negativeColor);
        }
        if (viewName === 'OpenAndAnswers') {
            if (parentModalDialog.data['reloadDashboard']) {
                parent.$('.h-questionNavigatorDashboard-table #DataTables_Table_0 tr td').each(function () {
                    var row = $(this).parents("tr");
                    if (selectedVariableId === row.data("variableId")) {
                        changeRowQuestionDisplay(row, true);
                        return false;
                    }
                });
            } else if (parentModalDialog.data['isResponseEdited']) {
                //  showUpdate();
            }
        }
    }

    if ((dashboardResults.selectedTopic == null || dashboardResults.selectedTopic == "") && $("#editTopicGlobalTracker").val() === "true") {
        refreshTopicTable(false);
    }
}

function refreshTopicTable(hasEdit) {
    var params = {
        variableId: $("#variableId").val() > 0 ? $("#variableId").val() : selectedVariableId,
        surveyId: a4.getSurveyId()
    };
    a4.callServerMethod(a4.getSurveyAction("GetTopicDataData", "AdvancedAnalytics"), params,
        function (response) {
            generateTopicTable(response['Topics'], hasEdit, response['DashboardColorScheme']['PositiveColor'], response['DashboardColorScheme']['NegativeColor'], response['DashboardColorScheme']['NeutralColor'], hasEdit);
        });
    $(".hideTopicEditButton").hide();
    if (hasEdit && $("#hasEdit").val() == "false") {
        $(".search").append("<input id='combine-topic' onclick='combineTopics()' type='button' class='button primary float-right' value='" + resources.Combine + "' />");
        $(".search").append("<input id='delete-topic' onclick='deleteTopics()' type='button' class='button primary float-right delete-topic' value='" + resources.Delete + "' />");
        $("#delete-topic").hide();
        $(".v-createSurvey").find(".title").html(resources.EditTopicsHeaderTitle)
    }
}

function setColorPickerValues(posColorId, neuColorId, negColorId) {
    var root = document.querySelector(':root');
    root.style.setProperty('--positive', posColorId);
    root.style.setProperty('--neutral', neuColorId);
    root.style.setProperty('--negative', negColorId);
}

function getDashboardColorScheme(variableId) {
    a4.callServerMethod(a4.getSurveyAction("GetSentimentDashboardColorScheme", "AdvancedAnalytics"), {
        variableId: variableId,
        surveyId: a4.getSurveyId()
    }, function (response) {
        if (response['PositiveColor'] && response['PositiveColor'] != '' && response['PositiveColor'] != null) {
            setColorPickerValues(response['PositiveColor'], response['NeutralColor'], response['NegativeColor']);
        }
    });
}

function openEndAnswerFullscreen(variableId, topicName, positiveCount, negativeCount, neutralCount, hasEdit = false, bindUpdatedResponse = false, selectedSentimentCategory = "", colorScheme = [], modifyDashboardPermissionAllowed = false) {
    dashboardResults.openEndAnswers = $(".open-end-answers");
    dashboardResults.selectedTopic = topicName;
    if (dashboardResults.openEndAnswersTable) {
        dashboardResults.openEndAnswersTable.a4datatable("option", "ajaxParams", { "variableId": variableId, "topicName": dashboardResults.selectedTopic, "filterAnalytics": filterAnalytics });
        dashboardResults.openEndAnswersTable.a4datatable("refresh", true, true);
    }
    else {
        dashboardResults.openEndAnswersTable = $(".open-end-answers-table", dashboardResults.openEndAnswers).a4datatable({
            ajaxAction: a4.getSurveyAction("GetOpenEndAnswers", "AdvancedAnalytics"),
            ajaxParams: { "variableId": variableId, "topicName": dashboardResults.selectedTopic, "filterAnalytics": filterAnalytics },
            multiEdit: modifyDashboardPermissionAllowed,
            columns: [
                {
                    "Key": true,
                    "Name": "RespondentId",
                    "Title": resources.Id,
                    "Data": "RespondentId",
                    "Visible": false,
                    "Type": "numeric"
                },
                {
                    "Name": "ResponseText",
                    "Title": resources.Comments,
                    "Data": "ResponseText",
                    "Sortable": false,
                    "Editable": true,
                    "Class": "response-text-edit"
                },
                {
                    "Name": "SentimentAnalytics",
                    "Title": resources.Sentiment,
                    "Data": "SentimentAnalytics",
                    "Sortable": false,
                    "Class": hasEdit ? "dis-n sentiment-text-column" : "dis-b sentiment-text-column"
                },
                {
                    "Name": "SentimentAnalytics",
                    "Title": resources.Sentiment,
                    "Class": "no-wrap",
                    "Type": "enum",
                    "Editable": { Nullable: false },
                    "EnumType": "ResponseType",
                    "Data": "SentimentAnalytics",
                    "Sortable": false,
                    "Class": hasEdit ? "dis-b sentiment-enum-column" : "dis-n sentiment-enum-column"
                }
            ],
            quickFilter: {
                "Items": [
                    { "Label": resources.Positive, "AjaxParams": { "status": "Positive" } },
                    { "Label": resources.Neutral, "AjaxParams": { "status": "Neutral" } },
                    { "Label": resources.Negative, "AjaxParams": { "status": "Negative" } }
                ]
            },
            loadData: function (event, data) {
                var result = data.result;
                openAndAnswersResultData = result.data;
            },
            localizableTexts: { "All": resources.Total, "Search": resources.SearchOpenEndQuestions },
            allowRowSelection: true,
            displayColumnSelector: false,
            displaySearchBox: true,
            rowsUpdated: function (event, data) {
                updateOpenAndAnswers();
            }
        });
    }
    if (bindUpdatedResponse) {
        updateOpenEndAnswerQuickFilterCounts(sentiments);
    } else {
        updateOpenEndAnswerQuickFilterWithCounts(positiveCount, negativeCount, neutralCount, colorScheme);
    }
    bindOpenEndQuickFilterClick(selectedSentimentCategory);
}

function selectTopic(target, targetIsRow) {
    var row = targetIsRow ? target : $(target).parents("tr");
    var editIcon = $(row).find(".fa-pencil");
    var selectAll = $('.h-selectAll');
    $(row).toggleClass("selected");
    var rollBackIcon = $(row).find(".fa-undo");
    if (rollBackIcon.hasClass("dis-n")) {
        rollBackIcon.removeClass("dis-n");
    } else {
        rollBackIcon.addClass("dis-n");
    }

    var selectedRowCount = $(row).parent().find("tr.selected").not("tr.header-row.selected").length;
    if (editIcon.hasClass("dis-n")) {
        editIcon.removeClass("dis-n");

        let tdWithoutPointer = $(row).find("td.removePointer")[0];
        if (tdWithoutPointer) {
            $(tdWithoutPointer).removeClass("removePointer");
            $(tdWithoutPointer).addClass("addPointer");
        }

        if (selectedRowCount == $("#topicTable").find("tr:has(.selectRow)").length) {
            if (selectAll.hasClass('fa-square-o')) {
                selectAll.removeClass('fa-square-o');
                selectAll.addClass("fa-check-square");
            }
        }
    }
    else {
        editIcon.addClass("dis-n");

        let tdWithPointer = $(row).find("td.addPointer")[0];
        if (tdWithPointer) {
            $(tdWithPointer).removeClass("addPointer");
            $(tdWithPointer).addClass("removePointer");
        }

        if (selectAll.hasClass('fa-check-square')) {
            selectAll.removeClass('fa-check-square');
            selectAll.addClass("fa-square-o");
        }
    }

    if (selectedRowCount > 0) {
        $("#delete-topic").show();
    } else {
        $("#delete-topic").hide();
    }

    if (selectedRowCount > 1) {
        $("#combine-topic").show();
    }
    else {
        $("#combine-topic").hide();
    }
}

// select all topics
$("#topicTable").on("click", ".h-selectAll", function () {
    var rows;
    if ($(this).hasClass("fa-square-o")) {
        rows = $("#topicTable").find("tr").not(".selected");
    }
    else {
        rows = $("#topicTable").find("tr:has(.selectRow)");
    }
    for (var i = 0; i < rows.length; i++) {
        selectTopic(rows[i], true);
    }
});

function combineTopics() {
    var dialogContent = { Title: resources.CombineTopicsTitle, Message: resources.CombineTopicsMessage, ConfirmButton: resources.Confirm };

    modalDialog.showConfirmDialog(dialogContent, function () {
        var topicsIds = [];
        var topicsNames = [];
        var keywordsNames = [];
        var selectedTopics = $(".topic-table").find(".selected").not("tr.header-row.selected");
        var positiveCount = 0, negativeCount = 0, neutralCount = 0;
        selectedTopics.each(function (index, element) {
            topicsIds.push($(element).find("span").data("id"));
            topicsNames.push($(element).find(".topic-name")[0].innerHTML);
            keywordsNames.push($(element).find(".topic-keyword")[0].innerHTML);
            variableId = $(element).find("span").data("variableid");
            positiveCount += parseInt($(element).find(".positive").attr("title"));
            negativeCount += parseInt($(element).find(".negative").attr("title"));
            neutralCount += parseInt($(element).find(".neutral").attr("title"));
        });

        var parameters = {
            surveyId: a4.getSurveyId(),
            topicsIds: topicsIds,
            topicsNames: topicsNames,
            keywordsNames: keywordsNames,
            variableId: variableId,
            positiveCount: positiveCount,
            negativeCount: negativeCount,
            neutralCount: neutralCount,
            combinedTopicIds: combinedTopicIds
        };
        a4.callServerMethod(a4.getSurveyAction("CombineTopics", "AdvancedAnalytics"), parameters
            , function (response) {
                if (response['Topics'].length != 0) {
                    $("#editTopicGlobalTracker", parent.document).val("true");
                    generateTopicTable(response['Topics'], true, response['DashboardColorScheme']['PositiveColor'], response['DashboardColorScheme']['NegativeColor'], response['DashboardColorScheme']['NeutralColor'], true);
                    $("#combine-topic").hide();
                    $("#delete-topic").hide();
                }
            })
    })
}

function editTopic(event) {
    var height = 250; var width = 400;
    var topicId = $(event).closest("tr").find(".icon-column span").data("id");
    var topicName = $(event).closest("tr").find(".topic-name").html();
    var selectedTopicKeywordForEdit = $(event).closest("tr").find(".topic-keyword").html();
    var variableId = $("#variableId").val();
    var params = {
        variableId: variableId,
        surveyId: a4.getSurveyId(),
        topicName: topicName,
        topicKeyword: selectedTopicKeywordForEdit,
        topicId: topicId
    };
    modalDialog.showWindow(a4.getSurveyAction("EditTopic", "AdvancedAnalytics",
        params), height, width, {
        afterClose: function () {
            if ($("#editTopicTracker").val() === "true") {
                refreshTopicTable(true);
            }
        }
    });
}

function cancelEditTopic() {
    $("#editTopicTracker", parent.document).val("false");
    return modalDialog.close();
}

function submitEditTopic() {
    $("#editTopicTracker", parent.document).val("true");
    $("#editTopicGlobalTracker", parent.parent.document).val("true");
    $("#editTopicForm").submit();
}

function rollBackTopicCombination(event) {
    var rollBackIcon = $(event).closest("tr").find(".fa-undo");
    if (rollBackIcon.hasClass("dis-n")) {
        return false;
    }
    var topicId = $(event).closest("tr").find(".icon-column span").data("id");
    var topicsKeywords = $(event).closest("tr").find(".icon-column span").data("topicskeywords");
    var dialogContent = { Title: resources.RollbackTopicCombinationHeader, Message: resources.RollbackTopicCombinationConfirmation, ConfirmButton: resources.Confirm };

    modalDialog.showConfirmDialog(dialogContent, function () {
        var parameters = {
            variableId: $('#variableId').val(),
            topicId: topicId,
            topicsKeywords: topicsKeywords
        };
        a4.callServerMethod(a4.getSurveyAction("RollbackTopicCombination", "AdvancedAnalytics"), parameters
            , function (response) {
                if (response['Topics'].length != 0) {
                    $("#editTopicTracker", document).val("true");
                    $("#editTopicGlobalTracker", parent.document).val("true");
                    a4.showSuccessMessage(resources.RollbackTopicCombinationSuccess);
                    generateTopicTable(response['Topics'], true, response['DashboardColorScheme']['PositiveColor'], response['DashboardColorScheme']['NegativeColor'], response['DashboardColorScheme']['NeutralColor'], true);
                    $("#combine-topic").hide();
                    $("#delete-topic").hide();
                }
            });
    })
}

function deleteTopics() {
    var selectedTopics = $(".topic-table").find(".selected").not("tr.header-row.selected");
    var totalRows = $("#topicTable").find("tr").length - 1;

    if (selectedTopics.length < totalRows) {
        var dialogContent = { Title: resources.DeleteTopicsHeader, Message: resources.DeleteTopicsConfirmation, ConfirmButton: resources.Confirm };
        modalDialog.showConfirmDialog(dialogContent, function () {
            var topicsIds = [];
            selectedTopics.each(function (index, element) {
                topicsIds.push($(element).find("span").data("id"));
            });
            var parameters = {
                variableId: $('#variableId').val(),
                topicsIds: topicsIds,
                combinedTopicIds: combinedTopicIds
            };
            a4.callServerMethod(a4.getSurveyAction("DeleteTopics", "AdvancedAnalytics"), parameters
                , function (response) {
                    if (response['Topics'].length != 0) {
                        $("#editTopicGlobalTracker", parent.document).val("true");
                        generateTopicTable(response['Topics'], true, response['DashboardColorScheme']['PositiveColor'], response['DashboardColorScheme']['NegativeColor'], response['DashboardColorScheme']['NeutralColor'], true);
                        $("#combine-topic").hide();
                        $("#delete-topic").hide();
                    }
                });
        });
    } else {
        a4.showErrorMessage(resources.AlertDeleteAllTopics);
    }
}